/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Vector;

public class TraceRecord
implements Comparable<TraceRecord> {
    private TraceContext context;
    private String textSummary;
    private BigInteger endTime = BigInteger.ZERO;
    BigInteger wrapTime = BigInteger.ZERO;
    BigInteger writePlatform = BigInteger.ZERO;
    private byte[] endTimeBytes = new byte[8];
    private byte[] wrapTimeBytes = new byte[8];
    BigInteger writeSystem = BigInteger.ZERO;
    long threadID;
    long threadSyn1;
    long threadSyn2;
    int firstEntry;
    int nextEntry;
    String threadName = "";
    private byte[] data;
    boolean lostRecord = false;
    boolean userDiscardedData = false;
    private static final byte[] userDiscardTracePoint = new byte[]{8, 0, 1, 0, 0, 0, 0, 0};
    public static final int TRACERECORD_HEADER_SIZE = 64;
    private static final int GUESSED_MAX_THREAD_NAME = 128;
    RandomAccessFile file;
    long offset;
    List<Integer> debugOffsets = null;

    public TraceRecord(TraceContext traceContext, byte[] byArray) throws IllegalArgumentException {
        this.context = traceContext;
        this.data = byArray;
        if (byArray.length != traceContext.getRecordSize()) {
            throw new IllegalArgumentException();
        }
        if (traceContext.debugLevel > 0) {
            this.debugOffsets = new Vector<Integer>();
        }
        this.parseHeader(byArray);
    }

    public TraceRecord(TraceContext traceContext, RandomAccessFile randomAccessFile, long l) throws IOException, IllegalArgumentException {
        this.context = traceContext;
        this.file = randomAccessFile;
        this.offset = l;
        int n = 192;
        if (traceContext.debugLevel > 0) {
            this.debugOffsets = new Vector<Integer>();
        }
        while (n != 0) {
            byte[] byArray = new byte[n];
            randomAccessFile.seek(l);
            if (randomAccessFile.read(byArray) != byArray.length) {
                throw new IllegalArgumentException();
            }
            n = this.parseHeader(byArray);
        }
        if (traceContext.debugStream != null) {
            traceContext.debug(this, 3, this.summary());
        }
    }

    private int parseHeader(byte[] byArray) throws IllegalArgumentException {
        ByteStream byteStream = this.context.createByteStream(byArray);
        byteStream.peek(this.endTimeBytes);
        this.endTime = byteStream.getBigInteger(8);
        byteStream.peek(this.wrapTimeBytes);
        this.wrapTime = byteStream.getBigInteger(8);
        this.writePlatform = byteStream.getBigInteger(8);
        this.writeSystem = byteStream.getBigInteger(8);
        this.threadID = byteStream.getLong();
        this.threadSyn1 = byteStream.getLong();
        this.threadSyn2 = byteStream.getLong();
        this.firstEntry = byteStream.getInt();
        this.nextEntry = byteStream.getInt();
        String string = null;
        if (string == null && this.firstEntry < 64) {
            string = "data passed to TraceRecord gives firstEntry[" + this.firstEntry + "] < header size[" + 64 + "]";
        }
        if (string == null && this.nextEntry > this.context.getRecordSize()) {
            string = "data passed to TraceRecord gives nextEntry[" + this.nextEntry + "] > record size[" + this.context.getRecordSize() + "]";
        }
        if (string == null && this.firstEntry > this.nextEntry && this.nextEntry != -1) {
            string = "data passed to TraceRecord gives firstEntry[" + this.firstEntry + "] > nextEntry[" + this.nextEntry + "]";
        }
        if (string != null) {
            this.context.error(this, string);
            throw new IllegalArgumentException(string);
        }
        if (byArray.length < this.firstEntry) {
            return this.firstEntry;
        }
        this.threadName = byteStream.getASCIIString(this.firstEntry - 64).intern();
        return 0;
    }

    private int load() {
        if (this.file != null && (this.data == null || this.data.length != this.context.getRecordSize())) {
            this.data = new byte[this.context.getRecordSize()];
            if (this.context.debugStream != null) {
                this.context.debug(this, 3, "Reading in full " + this.data.length + "byte record @" + this.offset);
            }
            int n = 0;
            try {
                this.file.seek(this.offset);
                n = this.file.read(this.data);
                if (n != this.data.length) {
                    this.context.error(this, "couldn't read an entire record from the file");
                    if (n <= this.nextEntry) {
                        return 0;
                    }
                    byte[] byArray = new byte[n];
                    System.arraycopy(this.data, 0, byArray, 0, n);
                    this.data = byArray;
                }
                return n;
            }
            catch (IOException iOException) {
                this.context.error(this, "IOException while reading record at offset " + this.offset);
                this.context.error(this, iOException.getMessage());
                return 0;
            }
        }
        return this.data.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int appendToStream(ByteStream byteStream, boolean bl) {
        int n;
        if (this.load() == 0) {
            return 0;
        }
        ++this.context.totalRecords;
        if (this.nextEntry == -1) {
            if (this.context.getTraceType() == 1) {
                byteStream.setGuardBytes(byteStream.getGuardBytes() + this.data.length - this.firstEntry);
                byteStream.add(this.data, this.firstEntry);
                return this.data.length - this.firstEntry;
            }
            this.context.warning(this, "Found \"middle of tracepoint record\" for internal trace record.");
            return 0;
        }
        if (this.nextEntry == this.context.getRecordSize()) {
            --this.nextEntry;
        }
        if (this.context.getTraceType() == 0) {
            byte[] byArray = new byte[this.data.length];
            n = this.nextEntry + 1;
            System.arraycopy(this.data, n, byArray, this.firstEntry, this.data.length - n);
            System.arraycopy(this.data, this.firstEntry, byArray, this.data.length - n + this.firstEntry, n - this.firstEntry);
            this.nextEntry = this.data.length - 1;
            this.data = byArray;
        }
        int n2 = this.nextEntry;
        n = this.nextEntry;
        byte by = this.data[n2];
        if (by == 0 && this.nextEntry - this.firstEntry > 7 && this.data[this.nextEntry - 1] == 8 && this.data[this.nextEntry - 8] == 0 && this.data[this.nextEntry - 7] == 0 && this.data[this.nextEntry - 6] == 0) {
            --n;
            --this.nextEntry;
            by = this.data[--n2];
            this.context.warning(this, "Fixed up misaligned sequence wrap trace point from defect 147869");
        }
        this.data[n2] = 0;
        int n3 = 0;
        int n4 = byteStream.getGuardBytes();
        boolean bl2 = true;
        byte[] byArray = new byte[8];
        byArray[0] = 8;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        if (this.context.metadata.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            System.arraycopy(this.endTimeBytes, 4, byArray, 4, 4);
        } else {
            System.arraycopy(this.endTimeBytes, 0, byArray, 4, 4);
        }
        while (n >= this.firstEntry && by != 0) {
            block74: {
                block76: {
                    byte by2;
                    block75: {
                        block73: {
                            int n5;
                            block69: {
                                block72: {
                                    block71: {
                                        int n6;
                                        n5 = by & 0xFF;
                                        n = n2 - n5;
                                        if (n5 != 4) break block71;
                                        byte[] byArray2 = new byte[4];
                                        if (n < this.firstEntry) {
                                            byte[] byArray3;
                                            block68: {
                                                byArray3 = new byte[this.firstEntry - n];
                                                try {
                                                    n6 = byteStream.truncate(byArray3);
                                                    n4 = byteStream.getGuardBytes();
                                                    if (n6 != byArray3.length) {
                                                        if (this.context.debugStream != null) {
                                                            this.context.debug(this, 4, "discarding spanned long trace point special because we failed retriving " + byArray3.length + "bytes, got " + n6);
                                                        }
                                                        bl2 = true;
                                                    }
                                                    break block68;
                                                }
                                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                                    if (this.context.debugStream != null) {
                                                        this.context.debug(this, 4, "discarding spanned long trace point special because we underflowed trying to get " + byArray3.length + "bytes");
                                                    }
                                                    bl2 = true;
                                                }
                                                break;
                                            }
                                            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                                            System.arraycopy(this.data, this.firstEntry, byArray2, byArray3.length, 4 - byArray3.length);
                                        } else {
                                            byArray2[0] = this.data[n2 - 4];
                                            byArray2[1] = this.data[n2 - 3];
                                            byArray2[2] = this.data[n2 - 2];
                                            byArray2[3] = this.data[n2 - 1];
                                        }
                                        by2 = byArray2[3];
                                        n6 = byArray2[0];
                                        n5 = (by2 & 0xFF) << 8 | n6 & 0xFF;
                                        if (byArray2[1] != 0 || byArray2[2] != 0) {
                                            if (n < this.firstEntry) {
                                                this.context.warning(this, "center 2 bytes for spanned long tracepoint special are not null, discarding remaining data");
                                            } else {
                                                this.context.error(this, "center 2 bytes for long tracepoint are not null, discarding remaining data");
                                            }
                                            bl2 = true;
                                            break;
                                        }
                                        if (this.context.debugStream != null) {
                                            this.context.debug(this, 4, "length for long tracepoint is " + n5);
                                        }
                                        if ((n = n2 - 4 - n5) >= this.firstEntry - 1) {
                                            System.arraycopy(this.data, n + 1, this.data, n + 5, n5 - 1);
                                            System.arraycopy(byArray2, 0, this.data, n + 1, byArray2.length);
                                            break block69;
                                        } else {
                                            int n7 = n2 - 4 - this.firstEntry;
                                            try {
                                                if (n7 > 0) {
                                                    byteStream.put(byArray2, n7 - n5 + 1);
                                                } else {
                                                    byteStream.put(byArray2, 0 - n5 + 1);
                                                }
                                                n4 = byteStream.getGuardBytes();
                                            }
                                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                                if (this.context.debugStream != null) {
                                                    this.context.warning(this, "Unable to insert long trace point special at index " + (n7 - n5 + 1) + " in the byte stream");
                                                }
                                                bl2 = true;
                                                break;
                                            }
                                            if (n7 > 0) {
                                                System.arraycopy(this.data, this.firstEntry, this.data, this.firstEntry + 4, n7);
                                                n3 += 4;
                                                break block69;
                                            } else {
                                                n3 += 4 + n7;
                                            }
                                        }
                                        break block69;
                                    }
                                    if (n5 != 8 || this.data[n + 1] != 0 || this.data[n + 3] != 0) break block69;
                                    if (this.data[n + 2] != 0) break block72;
                                    if (n > this.firstEntry) {
                                        byte[] byArray4 = new byte[8];
                                        byArray4[0] = 8;
                                        System.arraycopy(this.data, n + 1, byArray4, 1, 7);
                                        System.arraycopy(byArray, 1, this.data, n + 1, 7);
                                        byArray = byArray4;
                                        if (this.context.debugLevel > 0) {
                                            this.debugOffsets.add(n);
                                        }
                                        break block69;
                                    } else {
                                        int n8 = byteStream.getGuardBytes();
                                        if (n8 != 0 && n8 != this.firstEntry - n && this.context.debugStream != null) {
                                            this.context.debug(this, 4, "Sequence wrap trace point spans buffers but doesn't match fragment size from preceeding buffer, discarding both");
                                        }
                                        bl2 = true;
                                        break;
                                    }
                                }
                                if (n == this.firstEntry && this.data[n] == 0 && this.data[n + 2] == 1) {
                                    bl2 = true;
                                    this.lostRecord = true;
                                    if (this.context.debugLevel > 0) {
                                        this.debugOffsets.add(n);
                                    }
                                } else {
                                    this.context.error(this, "Special tracepoint (length is 8) and neither sequence wrap or lost record");
                                }
                            }
                            if (n <= this.firstEntry) break block73;
                            if (this.context.debugLevel >= 5) {
                                if (n5 > 12) {
                                    this.context.debug(this, 5, "fixing up tracepoint: " + new String(this.data, n + 12, Math.min(n5 - 12, 8)) + ", data[" + n + "] = " + (by & 0xFF));
                                } else {
                                    this.context.debug(this, 5, "fixing up special tracepoint, length " + n5);
                                }
                            }
                            byte by3 = this.data[n];
                            this.data[n] = by;
                            by = by3;
                            n2 = n;
                            if (this.context.debugLevel > 0) {
                                this.debugOffsets.add(n);
                            }
                            break block74;
                        }
                        if (n == this.firstEntry && this.data[this.firstEntry] == 0) {
                            if (n4 > 0) {
                                bl2 = true;
                            }
                            this.data[n] = by;
                            n2 = n;
                            if (this.context.debugLevel <= 0) break;
                            this.debugOffsets.add(n);
                            break;
                        }
                        if (n != this.firstEntry || this.data[this.firstEntry] == 0) break block75;
                        byte by4 = this.data[n];
                        this.data[n] = by;
                        by = by4;
                        n2 = n;
                        break block74;
                    }
                    if (this.context.getTraceType() != 1) break block76;
                    int n9 = n - this.firstEntry - n3;
                    if (this.context.debugStream != null) {
                        this.context.debug(this, 5, "Negative offset for fixup is " + n9);
                    }
                    if (n9 == -1) {
                        if (n4 == 1) {
                            byteStream.truncate(1);
                            bl2 = false;
                        } else {
                            bl2 = true;
                        }
                        this.data[n] = by;
                        n2 = n;
                        if (this.context.debugLevel > 0) {
                            this.debugOffsets.add(n);
                        }
                        break block74;
                    } else {
                        block70: {
                            if (n4 + n9 != 0 || this.userDiscardedData) {
                                bl2 = true;
                            } else {
                                if (this.context.debugStream != null) {
                                    this.context.debug(this, 5, "Trying to put byte into stream at offset " + n9 + " into " + byteStream.getGuardBytes() + " guard bytes");
                                }
                                try {
                                    by2 = byteStream.put(by, n9);
                                    if (by2 != 0) {
                                        bl2 = true;
                                        break block70;
                                    }
                                    if (this.context.debugStream != null) {
                                        this.context.debug(this, 5, "successfully fixed up earlier buffer");
                                    }
                                    bl2 = false;
                                    if (this.context.debugLevel > 0) {
                                        this.debugOffsets.add(n);
                                    }
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    this.context.error(this, "discarding end of spanned tracepoint for " + this.getIdentifier() + ", missing " + Math.abs(n9) + " bytes for start, discarding " + (n2 - this.firstEntry - n3) + " bytes");
                                    bl2 = true;
                                }
                            }
                        }
                        if (bl2 || n2 <= this.firstEntry) break;
                        byteStream.add(this.data, this.firstEntry + n3, n2 - this.firstEntry - n3);
                        break;
                    }
                }
                if (this.context.getTraceType() != 0) {
                    this.context.error(this, "Unknown trace type: " + this.context.getTraceType());
                }
                bl2 = true;
            }
            ++this.context.totalTracePoints;
        }
        if (bl2) {
            long l = Math.abs(n - this.firstEntry - n3);
            byteStream.truncate(n4);
            n3 = n2 - this.firstEntry;
            if (this.userDiscardedData && !this.lostRecord) {
                byteStream.add(userDiscardTracePoint);
            } else if (l != (long)n4) {
                if (this.lostRecord) {
                    this.context.debug(this, 4, "Discarding data depending on contents of lost records");
                } else if (l == 0L) {
                    this.context.debug(this, 4, "Previous record was likely flushed, discarding trailing data");
                } else if (!bl) {
                    this.context.warning(this, "Expected " + l + " of data from previous buffer for thread " + this.getIdentifier() + ", got " + n4 + " so discarded both inconsistent pieces");
                }
            }
        }
        if (this.context.debugStream != null) {
            this.context.debug(this, 4, "guarding " + (this.data.length - this.nextEntry) + "bytes");
        }
        byteStream.setGuardBytes(this.data.length - this.nextEntry);
        byteStream.add(byArray);
        if (this.context.debugLevel > 0) {
            this.debugOffsets.add(Integer.MIN_VALUE);
        }
        byteStream.add(this.data, n2);
        return this.data.length - (this.firstEntry + n3);
    }

    public String toString() {
        return this.getIdentifier();
    }

    private String getIdentifier() {
        return (this.threadID + this.threadName).intern();
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder("TraceRecord:" + System.getProperty("line.separator"));
            if (this.file != null) {
                stringBuilder.append("file offset:    " + this.offset).append(System.getProperty("line.separator"));
            } else {
                stringBuilder.append("non file data").append(System.getProperty("line.separator"));
            }
            stringBuilder.append("internal id:    ").append(this.toString()).append(System.getProperty("line.separator"));
            stringBuilder.append("endTime:        ").append(this.endTime).append(System.getProperty("line.separator"));
            stringBuilder.append("wrapTime:       ").append(this.wrapTime).append(System.getProperty("line.separator"));
            stringBuilder.append("writePlatform:  ").append(this.writePlatform).append(System.getProperty("line.separator"));
            stringBuilder.append("writeSystem:    ").append(this.writeSystem).append(System.getProperty("line.separator"));
            stringBuilder.append("threadID:       ").append("0x" + Long.toHexString(this.threadID)).append(System.getProperty("line.separator"));
            stringBuilder.append("threadSyn1:     ").append(this.threadSyn1).append(System.getProperty("line.separator"));
            stringBuilder.append("threadSyn2:     ").append(this.threadSyn2).append(System.getProperty("line.separator"));
            stringBuilder.append("firstEntry:     ").append(this.firstEntry).append(System.getProperty("line.separator"));
            stringBuilder.append("nextEntry:      ").append(this.nextEntry).append(System.getProperty("line.separator"));
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }

    @Override
    public int compareTo(TraceRecord traceRecord) {
        return this.wrapTime.compareTo(traceRecord.wrapTime);
    }
}

