/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.Message;
import com.ibm.jvm.trace.format.api.MessageFile;
import com.ibm.jvm.trace.format.api.NameValueTuple;
import com.ibm.jvm.trace.format.api.TraceFileHeader;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TraceRecord;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class TraceContext {
    protected static final int traceFormatMajorVersion = 2;
    protected static final int traceFormatMinorVersion = 0;
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int BYTE = 1;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int SIZE_T = -1;
    protected static final BigInteger MILLIS2SECONDS = BigInteger.valueOf(1000L);
    protected static final BigInteger SECONDS2MINUTES = BigInteger.valueOf(60L);
    protected static final BigInteger MINUTES2HOURS = BigInteger.valueOf(60L);
    protected static final BigInteger HOURS2DAYS = BigInteger.valueOf(24L);
    protected static final BigInteger MILLION = BigInteger.valueOf(1000000L);
    float version;
    BigInteger highPrecisionTicksPerMillisecond = BigInteger.valueOf(1000L);
    BigInteger lastWritePlatform = BigInteger.ZERO;
    BigInteger lastWriteSystem = BigInteger.ZERO;
    long totalTracePoints = 0L;
    long totalRecords = 0L;
    protected MessageFile messageFile;
    protected Vector auxiliaryMessageFiles;
    TraceFileHeader metadata;
    PrintStream errorStream = System.out;
    long errorCount = 0L;
    PrintStream warningStream = System.out;
    long warningCount = 0L;
    PrintStream messageStream = System.out;
    PrintStream debugStream = System.out;
    int debugLevel = 0;
    List threads = new ArrayList();
    Map threadMap = new HashMap();
    boolean sorted = false;
    Map knownThreads = new HashMap();
    private boolean recordThreadNames = false;
    Set filteredThreads;
    int timezoneOffset = 0;

    TraceContext(int n, ByteOrder byteOrder) {
        this.metadata = new TraceFileHeader(n, byteOrder);
    }

    private TraceContext(ByteBuffer byteBuffer, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        TraceFileHeader traceFileHeader;
        this.auxiliaryMessageFiles = new Vector();
        this.messageStream = printStream;
        this.warningStream = printStream3;
        this.errorStream = printStream2;
        this.debugStream = printStream4;
        this.metadata = traceFileHeader = new TraceFileHeader(this, byteBuffer);
    }

    private TraceContext(ByteBuffer byteBuffer, InputStream inputStream, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        this(byteBuffer, printStream, printStream2, printStream3, printStream4);
        this.messageFile = MessageFile.getMessageFile(inputStream, this);
    }

    private TraceContext(ByteBuffer byteBuffer, File file, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        this(byteBuffer, printStream, printStream2, printStream3, printStream4);
        this.messageFile = MessageFile.getMessageFile(file, this);
    }

    public void setRecordThreadNames(boolean bl) {
        this.recordThreadNames = bl;
        if (!bl) {
            this.knownThreads.clear();
        }
    }

    public boolean getRecordThreadNames() {
        return this.recordThreadNames;
    }

    public void warning(Object object, Object object2) {
        ++this.warningCount;
        if (this.warningStream != null) {
            this.warningStream.println(object2);
        }
    }

    public void error(Object object, Object object2) {
        ++this.errorCount;
        if (this.errorStream != null) {
            this.errorStream.println("Error: " + object2);
        }
    }

    public void message(Object object, Object object2) {
        if (this.messageStream != null) {
            this.messageStream.println(object2);
        }
    }

    public void debug(Object object, int n, Object object2) {
        if (this.debugStream != null && this.debugLevel >= n) {
            this.debugStream.println(object2);
        }
    }

    public void setErrorStream(PrintStream printStream) {
        this.errorStream = printStream;
    }

    public void setWarningStream(PrintStream printStream) {
        this.warningStream = printStream;
    }

    public void setDebugStream(PrintStream printStream) {
        this.debugStream = printStream;
    }

    public void setMessageStream(PrintStream printStream) {
        this.messageStream = printStream;
    }

    public float getVersion() {
        return this.version;
    }

    public String getVmVersionString() {
        return this.metadata.serviceSection.serviceString;
    }

    public BigInteger getHighPrecisionResolution() {
        return this.highPrecisionTicksPerMillisecond;
    }

    public int getRecordSize() {
        return this.metadata.recordSize;
    }

    public int getHeaderSize() {
        return this.metadata.dataHeader.length;
    }

    public int getHeaderSize(ByteBuffer byteBuffer) {
        byteBuffer.order(this.metadata.byteOrder);
        DataHeader dataHeader = new DataHeader(this, byteBuffer, "UTTH", false);
        return dataHeader.length;
    }

    public ByteOrder order() {
        return this.metadata.byteOrder;
    }

    public int getTraceType() {
        return this.metadata.traceSection.type;
    }

    @Deprecated
    public void setTraceType(int n) {
        boolean bl = true;
        if (this.debugStream != null) {
            String string;
            switch (n) {
                case 1: {
                    string = "External";
                    break;
                }
                case 0: {
                    string = "External";
                    break;
                }
                default: {
                    string = "<" + n + " is an invalid trace type>";
                    bl = false;
                }
            }
            this.debug(this, 1, "Forcing trace type to " + string + " at user request");
        }
        if (this.metadata != null && this.metadata.traceSection != null && bl) {
            this.metadata.traceSection.type = n;
        } else if (this.metadata == null || this.metadata.traceSection == null) {
            this.error(this, "Unable to set trace type due to incomplete trace context");
        } else {
            this.error(this, "Unable to set trace type to invalid type " + n);
        }
    }

    public long getTotalTracePoints() {
        return this.totalTracePoints;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getWarningCount() {
        return this.warningCount;
    }

    public void addMessageData(File file) throws IOException {
        this.auxiliaryMessageFiles.add(MessageFile.getMessageFile(new FileInputStream(file), this));
    }

    public void addMessageData(InputStream inputStream) throws IOException {
        this.auxiliaryMessageFiles.add(MessageFile.getMessageFile(inputStream, this));
    }

    public int getPointerSize() {
        return this.metadata.traceSection.pointerSize;
    }

    public static TraceContext getContext(ByteBuffer byteBuffer, File file) throws IOException {
        return TraceContext.getContext(byteBuffer, file, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] byArray, int n, File file) throws IOException {
        return TraceContext.getContext(byArray, n, file, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] byArray, int n, File file, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        return TraceContext.getContext(ByteBuffer.wrap(byArray, 0, n), file, printStream, printStream2, printStream3, printStream4);
    }

    public static TraceContext getContext(ByteBuffer byteBuffer, InputStream inputStream) throws IOException {
        return TraceContext.getContext(byteBuffer, inputStream, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] byArray, int n, InputStream inputStream) throws IOException {
        return TraceContext.getContext(byArray, n, inputStream, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] byArray, int n, InputStream inputStream, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        return TraceContext.getContext(ByteBuffer.wrap(byArray, 0, n), inputStream, printStream, printStream2, printStream3, printStream4);
    }

    public static TraceContext getContext(ByteBuffer byteBuffer, File file, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        return new TraceContext(byteBuffer, file, printStream, printStream3, printStream2, printStream4);
    }

    public static TraceContext getContext(ByteBuffer byteBuffer, InputStream inputStream, PrintStream printStream, PrintStream printStream2, PrintStream printStream3, PrintStream printStream4) throws IOException {
        return new TraceContext(byteBuffer, inputStream, printStream, printStream3, printStream2, printStream4);
    }

    ByteStream createByteStream() {
        ByteStream byteStream = new ByteStream();
        byteStream.order(this.metadata.byteOrder);
        return byteStream;
    }

    ByteStream createByteStream(byte[] byArray) {
        return this.createByteStream(byArray, 0);
    }

    ByteStream createByteStream(byte[] byArray, int n) {
        return this.createByteStream(byArray, n, byArray.length - n);
    }

    ByteStream createByteStream(byte[] byArray, int n, int n2) {
        ByteStream byteStream = new ByteStream(byArray);
        byteStream.order(this.metadata.byteOrder);
        return byteStream;
    }

    synchronized void threadTerminated(TraceThread traceThread, boolean bl) {
        if (this.debugStream != null) {
            this.debug(this, 2, "Thread " + traceThread + " terminated, removing thread from thread list? " + bl);
        }
        if (!bl) {
            Long l = traceThread.getThreadID();
            this.knownThreads.remove(l);
            this.threadMap.remove(l);
            this.threads.remove(traceThread);
        }
    }

    private synchronized TraceThread addData(TraceRecord traceRecord) {
        TraceThread traceThread;
        Object object;
        Long l = traceRecord.threadID;
        if (traceRecord.threadName.equals("Exception trace pseudo-thread")) {
            // empty if block
        }
        if (this.recordThreadNames) {
            if (this.knownThreads.containsKey(l)) {
                object = (Set)this.knownThreads.get(l);
                object.add(traceRecord.threadName);
            } else {
                object = new HashSet<String>();
                object.add(traceRecord.threadName);
                this.knownThreads.put(l, object);
            }
        }
        if ((traceThread = (TraceThread)this.threadMap.get(l)) == null || traceThread.stream == null) {
            traceThread = new TraceThread(this, traceRecord.threadID, traceRecord.threadSyn1, traceRecord.threadName);
            this.threads.add(traceThread);
            this.threadMap.put(l, traceThread);
            this.sorted = false;
        } else {
            this.metadata.traceSection.type = 1;
        }
        if (traceRecord.writePlatform.compareTo(this.lastWritePlatform) > 0) {
            this.lastWritePlatform = traceRecord.writePlatform;
        }
        if (traceRecord.writeSystem.compareTo(this.lastWriteSystem) > 0) {
            this.lastWriteSystem = traceRecord.writeSystem;
        }
        if (this.metadata.traceSection.startPlatform.compareTo(BigInteger.ZERO) != 0 && this.metadata.traceSection.startSystem != this.lastWriteSystem) {
            object = this.lastWriteSystem.subtract(this.metadata.traceSection.startSystem);
            this.highPrecisionTicksPerMillisecond = ((BigInteger)object).compareTo(BigInteger.ZERO) == 0 ? this.lastWritePlatform.subtract(this.metadata.traceSection.startPlatform) : this.lastWritePlatform.subtract(this.metadata.traceSection.startPlatform).divide((BigInteger)object);
        }
        if (this.filteredThreads == null || this.filteredThreads.contains(traceRecord.threadID)) {
            traceThread.addRecord(traceRecord);
        }
        return traceThread;
    }

    public TraceThread addData(RandomAccessFile randomAccessFile, long l) throws IOException {
        return this.addData(new TraceRecord(this, randomAccessFile, l));
    }

    public TraceThread addData(byte[] byArray) {
        return this.addData(new TraceRecord(this, byArray));
    }

    public synchronized void discardedData() {
        for (TraceThread traceThread : this.threads) {
            traceThread.userDiscardedData();
        }
    }

    public BigInteger getStartPlatform() {
        return this.metadata.traceSection.startPlatform;
    }

    public BigInteger getStartSystem() {
        return this.metadata.traceSection.startSystem;
    }

    public Iterator getThreads() {
        return new ThreadListIterator(this.threads);
    }

    public Iterator getTracepoints() {
        return new SortedTracepointIterator();
    }

    public void addThreadToFilter(Long l) {
        if (this.filteredThreads == null) {
            this.filteredThreads = new TreeSet();
        }
        this.filteredThreads.add(l);
    }

    public void setTimeZoneOffset(int n) {
        this.timezoneOffset = n;
    }

    final String getFormattedTime(BigInteger bigInteger) {
        switch (this.metadata.processorSection.counter) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                if ((double)this.version >= 1.1) {
                    long l = bigInteger.subtract(this.metadata.traceSection.startPlatform).longValue();
                    long l2 = this.highPrecisionTicksPerMillisecond.longValue();
                    long l3 = l / l2 + this.metadata.traceSection.startSystem.longValue() + (long)(this.timezoneOffset * 60 * 1000);
                    long l4 = l3 % 1000L * 1000000L + l % l2 * 1000000L / l2;
                    long l5 = l3 / 1000L % 60L;
                    long l6 = l3 / 1000L / 60L % 60L;
                    long l7 = l3 / 1000L / 60L / 60L % 24L;
                    return (l7 < 10L ? "0" : "") + l7 + ":" + (l6 < 10L ? "0" : "") + l6 + ":" + (l5 < 10L ? "0" : "") + l5 + "." + "000000000".substring((l4 + "").length()) + l4;
                }
                return "0000000000000000".substring(bigInteger.toString(16).length()) + bigInteger.toString(16);
            }
            case 3: {
                long l = (bigInteger.shiftRight(32).longValue() & 0xFFFFFFFFL) + (long)(this.timezoneOffset * 60);
                long l8 = bigInteger.longValue() & 0xFFFFFFFFL;
                long l9 = l % 60L;
                long l10 = l / 60L % 60L;
                long l11 = l / 3600L % 24L;
                try {
                    return "00".substring(Long.toString(l11).length()) + Long.toString(l11) + ":" + "00".substring(Long.toString(l10).length()) + Long.toString(l10) + ":" + "00".substring(Long.toString(l9).length()) + Long.toString(l9) + "." + "000000000".substring(Long.toString(l8).length()) + Long.toString(l8);
                }
                catch (Exception exception) {
                    this.debug(this, 1, "hh: " + Long.toString(l11) + " mm: " + Long.toString(l10) + " ss: " + Long.toString(l9) + " Nanos: " + Long.toString(l8));
                    return "Bad Time: " + bigInteger.toString(16);
                }
            }
            case 6: {
                long l = (bigInteger.shiftRight(12).longValue() & 0xFFFFFFFFFFFFFL) + (long)(this.timezoneOffset * 60 * 1000000);
                long l12 = l / 1000000L % 60L;
                long l13 = l / 60000000L % 60L;
                long l14 = (l / 3600000000L + (long)this.timezoneOffset) % 24L;
                long l15 = (bigInteger.longValue() & 0xFFFL | (l %= 1000000L) << 12) * 244140625L / 1000000L;
                try {
                    return "00".substring(Long.toString(l14).length()) + Long.toString(l14) + ":" + "00".substring(Long.toString(l13).length()) + Long.toString(l13) + ":" + "00".substring(Long.toString(l12).length()) + Long.toString(l12) + "." + "000000000000".substring(Long.toString(l15).length()) + Long.toString(l15);
                }
                catch (Exception exception) {
                    this.debug(this, 1, "hh: " + Long.toString(l14) + " mm: " + Long.toString(l13) + " ss: " + Long.toString(l12) + " Picos: " + Long.toString(l15));
                    return "Bad Time: " + bigInteger.toString(16);
                }
            }
        }
        return "0000000000000000".substring(bigInteger.toString(16).length()) + bigInteger.toString(16);
    }

    public String formatPointer(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Long.numberOfLeadingZeros(l) / 4;
        if (this.getPointerSize() == 4) {
            n -= 8;
        }
        stringBuilder.append("0x0000000000000000".substring(0, n + 2));
        if (l > 0L) {
            stringBuilder.append(Long.toHexString(l));
        }
        return stringBuilder.toString();
    }

    public String summary() {
        StringBuilder stringBuilder = new StringBuilder("                Trace Summary" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        stringBuilder.append(this.metadata.serviceSection.summary());
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(this.metadata.startupSection.summary());
        stringBuilder.append(this.metadata.processorSection.summary());
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(this.metadata.activeSection.summary());
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(this.metadata.traceSection.summary());
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Active threads" + System.getProperty("line.separator"));
        for (Long l : this.knownThreads.keySet()) {
            Set set = (Set)this.knownThreads.get(l);
            int n = set.size();
            stringBuilder.append("        " + this.formatPointer(l));
            if (n > 1) {
                stringBuilder.append("  (id reused)" + System.getProperty("line.separator"));
                for (String string : set) {
                    stringBuilder.append("        ");
                    if (this.getPointerSize() == 4) {
                        stringBuilder.append("            " + string + System.getProperty("line.separator"));
                        continue;
                    }
                    stringBuilder.append("                    " + string + System.getProperty("line.separator"));
                }
                continue;
            }
            for (String string : set) {
                stringBuilder.append("  " + string + System.getProperty("line.separator"));
            }
        }
        stringBuilder.append(System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    public void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    public String statistics() {
        Object object;
        CharSequence charSequence;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        HashMap hashMap = this.messageFile.getStatistics();
        for (int i = 0; i < this.auxiliaryMessageFiles.size(); ++i) {
            hashMap.putAll(((MessageFile)this.auxiliaryMessageFiles.get(i)).getStatistics());
        }
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
        Vector<NameValueTuple> vector = new Vector<NameValueTuple>();
        TreeMap<CharSequence, Long> treeMap2 = new TreeMap<CharSequence, Long>();
        Vector<NameValueTuple> vector2 = new Vector<NameValueTuple>();
        Vector<NameValueTuple> vector3 = new Vector<NameValueTuple>();
        Iterator<Object> iterator = hashMap.keySet().iterator();
        long l3 = 0L;
        while (iterator.hasNext()) {
            Long l4;
            charSequence = (String)iterator.next();
            object = (Properties)hashMap.get(charSequence);
            String object2 = ((Properties)object).getProperty("component", "");
            int n2 = ((String)charSequence).length();
            if (n2 > n) {
                n = n2;
            }
            if (((Properties)object).containsKey("count")) {
                long l5 = (Long)((Properties)object).get("count");
                if (l5 > l) {
                    l = l5;
                }
                treeMap2.put(charSequence, l5);
                vector2.add(new NameValueTuple((String)charSequence, (Long)((Properties)object).get("count")));
            }
            if (!((Properties)object).containsKey("bytes") || (l4 = (Long)((Properties)object).get("bytes")) == null) continue;
            long l6 = l4;
            if (l6 > l2) {
                l2 = l6;
            }
            l3 += l6;
            vector3.add(new NameValueTuple((String)charSequence, (Long)((Properties)object).get("bytes")));
            long l7 = 0L;
            if (treeMap.containsKey(object2)) {
                l7 = (Long)treeMap.get(object2);
            }
            treeMap.put(object2, l7 + l6);
        }
        charSequence = new StringBuffer();
        object = System.getProperty("line.separator");
        ((StringBuffer)charSequence).append("Component totals (bytes)" + (String)object);
        for (String string : treeMap.keySet()) {
            vector.add(new NameValueTuple(string, (Long)treeMap.get(string)));
        }
        Collections.sort(vector);
        for (NameValueTuple nameValueTuple : vector) {
            ((StringBuffer)charSequence).append(String.format("%-" + n + "s %d%n", nameValueTuple.name() + ":", nameValueTuple.value()));
        }
        ((StringBuffer)charSequence).append("Total bytes: " + l3).append((String)object);
        ((StringBuffer)charSequence).append((String)object);
        ((StringBuffer)charSequence).append("Trace point counts:" + (String)object);
        Collections.sort(vector2);
        for (NameValueTuple nameValueTuple : vector2) {
            String string = nameValueTuple.name();
            Message message = this.messageFile.getMessageFromID(string.substring(0, string.indexOf(46)), Integer.parseInt(string.substring(string.indexOf(46) + 1)));
            ((StringBuffer)charSequence).append(String.format("%-" + n + "s %d (level: %2d)%n", nameValueTuple.name() + ":", nameValueTuple.value(), message.getLevel()));
        }
        ((StringBuffer)charSequence).append((String)object);
        ((StringBuffer)charSequence).append("Trace point totals (bytes):" + (String)object);
        Collections.sort(vector3);
        for (NameValueTuple nameValueTuple : vector3) {
            String string = nameValueTuple.name();
            Message message = this.messageFile.getMessageFromID(string.substring(0, string.indexOf(46)), Integer.parseInt(string.substring(string.indexOf(46) + 1)));
            ((StringBuffer)charSequence).append(String.format("%-" + n + "s %-" + (Math.log10(l2) + 1.0) + "d (%6.2f%%, level: %2d, hit count: %-" + (Math.log10(l) + 1.0) + "d)%n", nameValueTuple.name() + ":", nameValueTuple.value(), ((Long)nameValueTuple.value()).doubleValue() * 100.0 / (double)l3, message.getLevel(), treeMap2.get(nameValueTuple.name())));
        }
        return ((StringBuffer)charSequence).toString();
    }

    class SortedTracepointIterator
    implements Iterator {
        SortedTracepointIterator() {
        }

        @Override
        public boolean hasNext() {
            this.sort();
            if (TraceContext.this.threads.size() > 0) {
                return ((TraceThread)TraceContext.this.threads.get(0)).getIterator().hasNext();
            }
            return false;
        }

        public Object next() {
            this.sort();
            TracePoint tracePoint = (TracePoint)((TraceThread)TraceContext.this.threads.get(0)).getIterator().next();
            TraceContext.this.sorted = true;
            return tracePoint;
        }

        private void sort() {
            if (!TraceContext.this.sorted) {
                for (int i = 0; i < TraceContext.this.threads.size(); ++i) {
                    ((TraceThread)TraceContext.this.threads.get(i)).refresh();
                }
                Collections.sort(TraceContext.this.threads);
                TraceContext.this.sorted = true;
            } else if (TraceContext.this.threads.size() > 1 && ((TraceThread)TraceContext.this.threads.get(0)).compareTo(TraceContext.this.threads.get(1)) > 0) {
                TraceThread traceThread = (TraceThread)TraceContext.this.threads.get(0);
                TraceContext.this.threads.remove(0);
                Iterator iterator = TraceContext.this.threads.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    if (traceThread.compareTo(iterator.next()) <= 0) {
                        TraceContext.this.threads.add(n, traceThread);
                        traceThread = null;
                        break;
                    }
                    ++n;
                }
                if (traceThread != null) {
                    TraceContext.this.threads.add(traceThread);
                }
                TraceContext.this.sorted = true;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ThreadListIterator
    implements Iterator {
        Object threadCursor = null;
        List threads = null;
        Iterator iterator;

        ThreadListIterator(List list) {
            this.threads = list;
            this.iterator = this.threads.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.threadCursor != null;
        }

        public Object next() {
            Object object = null;
            List list = this.threads;
            synchronized (list) {
                try {
                    if (this.threadCursor == null) {
                        this.threadCursor = this.iterator.next();
                    }
                    object = this.threadCursor;
                    this.threadCursor = this.iterator.next();
                    return object;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    if (this.threadCursor != null) {
                        Iterator iterator = this.threads.iterator();
                        while (iterator.hasNext() && iterator.next() != this.threadCursor) {
                        }
                        this.iterator = iterator;
                        return this.next();
                    }
                    throw concurrentModificationException;
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.threadCursor = null;
                    if (object != null) {
                        return object;
                    }
                    throw noSuchElementException;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

