/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public class TracePoint
implements Comparable,
com.ibm.jvm.trace.TracePoint {
    private static final String CHANGE_OF_THREAD_INDICATOR = "*";
    private String componentName = null;
    private String containerComponentName = null;
    private int tracepointID = -1;
    private byte[] parameterData = null;
    private BigInteger rawTimeStamp = null;
    private long threadID = -1L;
    private boolean isChangeOfThread = false;
    private int tplen = -1;
    private String padding = null;
    private static String compNamePadding = "          ";
    private static String tpIDPadding = "    ";
    private boolean isLongTracePoint = false;
    private int longTracePointLength = 0;
    private boolean isNormalTracepoint = true;
    private boolean isInvalid = false;
    private boolean isLostRecord = false;
    private long lostRecordCount = 0L;
    private long startOffsetInTraceFile = -1L;
    private long endOffsetInTraceFile = -1L;
    private boolean fragmented = false;
    private String nameOfTraceFile = null;
    private boolean isNewTimerUpperWord = false;
    private long newTimerUpperWord = -1L;
    BigInteger upperWord = null;

    public TracePoint(byte[] byArray, int n, BigInteger bigInteger, long l, String string, long l2, long l3, boolean bl) {
        this.upperWord = bigInteger;
        this.threadID = l;
        this.nameOfTraceFile = string;
        this.startOffsetInTraceFile = l2;
        this.endOffsetInTraceFile = l3;
        this.fragmented = bl;
        this.parseDataIntoTracepoint(byArray, n);
        this.padding = Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4 ? "            " : "                    ";
    }

    private TracePoint parseDataIntoTracepoint(byte[] byArray, int n) {
        int n2;
        int n3;
        if (n == 0) {
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (byArray == null) {
            TraceFormat.outStream.println("TracePoint passed null data array - can't extract tracepoint from it. " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.tplen = n;
        if (this.tplen == 0) {
            TraceFormat.outStream.println("Tracepoint extracted zero from first byte of trace data - returning without creating tracepoint " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (byArray.length < n) {
            Util.Debug.println("Partial buffer passed in - most likely partly overwritten during a buffer wrap");
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.tracepointID = Util.constructTraceID(byArray, 1);
        this.tracepointID &= 0x3FFF;
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 1 && byArray[3] == 0 && this.tplen == 8) {
            Util.Debug.println("Lost Record TracePoint detected, should have been handled by TraceRecord50 " + this.from());
            this.isNormalTracepoint = false;
            this.isLostRecord = true;
            this.lostRecordCount = Util.constructUnsignedInt(byArray, 4);
            return this;
        }
        if (this.tracepointID == 0) {
            this.isNormalTracepoint = false;
            if (this.tplen != 8) {
                Util.Debug.println("Possible inconsistency in buffer - tracePointID 0 detected but length = " + this.tplen);
                Util.Debug.println("Ignoring this tracepoint for now - inspect tracefile for further details " + this.from());
                this.isInvalid = true;
                return this;
            }
            long l = Util.constructUnsignedInt(byArray, 4);
            this.isNormalTracepoint = false;
            this.isNewTimerUpperWord = true;
            this.newTimerUpperWord = l;
            Util.Debug.println("Sequence wrap found, value = " + l + " " + this.from());
            return this;
        }
        if (this.tplen == 4) {
            if (byArray[1] == 0 && byArray[2] == 0) {
                Util.Debug.println("Long entry data");
                int n4 = Util.constructUnsignedByte(byArray, 3);
                int n5 = Util.constructUnsignedByte(byArray, 0);
                this.longTracePointLength = n5 | n4 << 8;
                Util.Debug.println(" longEntryID = " + n4 + " length = " + this.longTracePointLength + " " + this.from());
                this.isLongTracePoint = true;
                this.componentName = "longtracepoint id";
                this.isNormalTracepoint = false;
                return this;
            }
            Util.Debug.println("Found a 4 byte length tracepoint that doesn't seem to contain a long tracepoint marker" + this.from());
            Util.Debug.println("Incorrect long tracepoint found - bytes 1 and 2 aren;t zero (as they should be):");
            Util.Debug.println("    byte 1 == " + Byte.toString(byArray[1]) + " byte 2 == " + Byte.toString(byArray[2]));
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return null;
        }
        BigInteger bigInteger = Util.constructUnsignedLong(byArray, 4, 4);
        this.rawTimeStamp = this.upperWord.shiftLeft(32).or(bigInteger);
        long l = Util.constructUnsignedInt(byArray, 8);
        if (l <= 0L || l > (long)this.tplen) {
            Util.Debug.println("TracePoint.parseDataIntoTracepoint() detected bad component name length: " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.componentName = Util.constructString(byArray, 12, (int)l);
        if (this.componentName == null || this.componentName.length() == 0) {
            Util.Debug.println("TracePoint.parseDataIntoTracepoint() detected bad component name: " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.componentName.equals("INTERNALTRACECOMPONENT")) {
            this.componentName = "dg";
        } else {
            this.tracepointID -= 257;
        }
        int n6 = this.componentName.indexOf("(");
        if (n6 >= 0) {
            String string;
            n3 = this.componentName.indexOf(")");
            if (n3 < 0 || n3 < n6) {
                Util.Debug.println("Overriding closeBracketIndex - not found in [" + this.componentName + "]");
                n3 = this.componentName.length();
            }
            this.containerComponentName = this.componentName.substring(n6 + 1, n3);
            this.componentName = string = this.componentName.substring(0, n6);
        }
        if ((n2 = this.tplen - (n3 = 12 + (int)l)) > 0) {
            this.parameterData = new byte[n2];
            System.arraycopy(byArray, n3, this.parameterData, 0, n2);
        }
        return this;
    }

    public boolean isLongTracePoint() {
        return this.isLongTracePoint;
    }

    public int longTracePointLength() {
        if (this.isLongTracePoint) {
            return this.longTracePointLength;
        }
        Util.Debug.println("longTracePointLength called on a completed tracepoint");
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Util.formatAsHexString(this.threadID);
        if (this.isChangeOfThread) {
            stringBuffer.append(this.padding.substring(Math.min(string.length() + 1, this.padding.length())));
            stringBuffer.append(CHANGE_OF_THREAD_INDICATOR);
        } else {
            stringBuffer.append(this.padding.substring(Math.min(string.length(), this.padding.length())));
        }
        stringBuffer.append(string);
        String string2 = TraceFormat.getUserVMIdentifier();
        if (string2 != null) {
            stringBuffer.append(" " + string2);
        }
        if (this.isLostRecord) {
            stringBuffer.append(" " + this.lostRecordCount + " trace buffers of data were discarded for this thread");
            return stringBuffer.toString();
        }
        if (this.componentName.length() < compNamePadding.length()) {
            stringBuffer.append(compNamePadding.substring(this.componentName.length()));
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.componentName);
        if (this.containerComponentName != null) {
            stringBuffer.append("(" + this.containerComponentName + ")");
        }
        stringBuffer.append(".");
        stringBuffer.append(this.tracepointID);
        if (Integer.toString(this.tracepointID).length() < tpIDPadding.length()) {
            stringBuffer.append(tpIDPadding.substring(Integer.toString(this.tracepointID).length()));
        }
        return stringBuffer.toString();
    }

    public String getFileName() {
        return this.nameOfTraceFile;
    }

    public long getOffsetInTraceFile() {
        return this.startOffsetInTraceFile;
    }

    public int getTPID() {
        return this.tracepointID;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getContainerComponentName() {
        return this.containerComponentName;
    }

    @Override
    public long getThreadID() {
        return this.threadID;
    }

    public String getParameterDataFormatted() {
        Message message = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        byte[] byArray = this.getParmData();
        String string = null;
        if (byArray == null) {
            byArray = new byte[1];
            try {
                string = message.getMessage(byArray, 0, 0);
            }
            catch (Exception exception) {
                string = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
            }
        } else {
            try {
                string = message.getMessage(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                string = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
            }
        }
        return string;
    }

    public byte[] getParmData() {
        return this.parameterData;
    }

    public BigInteger getRawTimeStamp() {
        return this.rawTimeStamp;
    }

    void setRawTimeStamp(BigInteger bigInteger) {
        this.rawTimeStamp = bigInteger;
    }

    public boolean isTimerUpperWord() {
        return this.isNewTimerUpperWord;
    }

    public long getNewTimerUpperWord() {
        if (this.isNewTimerUpperWord) {
            return this.newTimerUpperWord;
        }
        TraceFormat.outStream.println("an attempt to get a new timer upper word has been made on a tracepoint that doesn't seem to be a timer wrap!");
        TraceFormat.outStream.println(" tracepoint = " + this.tracepointID + "." + this.componentName);
        return -1L;
    }

    public boolean setTracePointsUpperWord(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger == null) {
            TraceFormat.outStream.println(" attempt made to set the upper word of tracepoint to a null - original tracepoint: " + this.from());
            return false;
        }
        if (this.rawTimeStamp == null) {
            TraceFormat.outStream.println(" attempt made to set the upper word on a tracepoint whose timestamp is null - original tracepoint: " + this.from());
            return false;
        }
        this.rawTimeStamp = bigInteger2 = bigInteger.shiftLeft(32).or(this.rawTimeStamp);
        return true;
    }

    public boolean isNormalTracepoint() {
        return this.isNormalTracepoint;
    }

    public boolean isLostRecord() {
        return this.isLostRecord;
    }

    public int compareTo(Object object) {
        if (this.rawTimeStamp == null) {
            TraceFormat.outStream.println("TracePoint compareTo called on TracePoint with no rawTimeStamp");
            return 0;
        }
        if (((TracePoint)object).getRawTimeStamp() == null) {
            TraceFormat.outStream.println("TracePoint compareTo called with a TracePoint with no rawTimeStamp");
            return 0;
        }
        return this.rawTimeStamp.compareTo(((TracePoint)object).getRawTimeStamp());
    }

    @Override
    public String getFormattedParameters() {
        return this.getParameterDataFormatted();
    }

    @Override
    public String getFormattedTime() {
        return Util.getFormattedTime(this.getRawTimeStamp());
    }

    public void setIsChangeOfThread(boolean bl) {
        this.isChangeOfThread = bl;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public int getTypeAsInt() {
        Message message = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        return message.getType();
    }

    @Override
    public int getID() {
        return this.getTPID();
    }

    @Override
    public long getTimestampMillis() {
        return 0L;
    }

    @Override
    public int getMicrosecondsCount() {
        return 0;
    }

    @Override
    public String getComponent() {
        return this.getComponentName();
    }

    @Override
    public String getContainerComponent() {
        return this.getContainerComponentName();
    }

    @Override
    public String getParameterFormattingTemplate() {
        Message message = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        return message.getFormattingTemplate();
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getGroups() {
        return null;
    }

    @Override
    public int getLevel() {
        return -1;
    }

    @Override
    public String getType() {
        Message message = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        int n = message.getType();
        return TraceRecord.types[n];
    }

    public String from() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("from: 0x");
        stringBuffer.append(Long.toHexString(this.startOffsetInTraceFile));
        stringBuffer.append("->0x");
        stringBuffer.append(Long.toHexString(this.endOffsetInTraceFile));
        stringBuffer.append(":");
        if (this.fragmented) {
            stringBuffer.append("F");
            if (this.startOffsetInTraceFile == -1L) {
                stringBuffer.append("I");
            } else if (this.startOffsetInTraceFile == -2L) {
                stringBuffer.append("E");
            } else {
                stringBuffer.append("X");
            }
        }
        stringBuffer.append(":");
        stringBuffer.append(this.nameOfTraceFile);
        return stringBuffer.toString();
    }
}

