/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

class OutputFile
extends ProgramOption {
    PrintWriter outputStream;

    OutputFile() {
    }

    @Override
    String getDescription() {
        return "The output file containing the formatted trace data. The default is to append \".fmt\" to the input file name";
    }

    @Override
    String getName() {
        return "output_file";
    }

    @Override
    Object getValue() {
        return this.outputStream;
    }

    @Override
    void setDefault() {
        if (ProgramOption.AnonymousArgs.isEmpty()) {
            throw new IllegalArgumentException("An input file must be specified before the output file when using anonymous arguments to specify input/output files");
        }
        if (ProgramOption.AnonymousArgs.size() == 1) {
            this.setValue(ProgramOption.AnonymousArgs.get(0).toString() + ".fmt");
        } else if (ProgramOption.AnonymousArgs.size() == 2) {
            this.setValue(ProgramOption.AnonymousArgs.get(1).toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer("Usage error: too many positional arguments:" + System.getProperty("line.separator"));
            for (int i = 2; i < ProgramOption.AnonymousArgs.size(); ++i) {
                stringBuffer.append(ProgramOption.AnonymousArgs.get(i)).append(System.getProperty("line.separator"));
            }
            stringBuffer.append(System.getProperty("line.separator") + OutputFile.help());
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    @Override
    void setValue(String string) throws IllegalArgumentException {
        try {
            String string2 = System.getProperty("file.encoding", "UTF-8");
            try {
                this.outputStream = new PrintWriter(new File(string), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Unable to set encoding of output file to UTF-8. Some formatted data may not be readable.");
                this.outputStream = new PrintWriter(new File(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Unable to create file \"" + string + "\" for writing");
        }
        System.out.println("Writing formatted trace output to file " + string);
    }
}

