/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.font.GlyphVector;
import sun.font.StandardGlyphVector;
import sun.font.StrikeCache;
import sun.java2d.loops.FontInfo;

public final class GlyphList {
    private static final int MINGRAYLENGTH = 1024;
    private static final int MAXGRAYLENGTH = 8192;
    private static final int DEFAULT_LENGTH = 32;
    int glyphindex;
    int[] metrics;
    byte[] graybits;
    Object strikelist;
    int len = 0;
    int maxLen = 0;
    int maxPosLen = 0;
    int[] glyphData;
    char[] chData;
    long[] images;
    float[] positions;
    float x;
    float y;
    float gposx;
    float gposy;
    boolean usePositions;
    boolean lcdRGBOrder;
    boolean lcdSubPixPos;
    private static GlyphList reusableGL = new GlyphList();
    private static boolean inUse;

    void ensureCapacity(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.usePositions && n > this.maxPosLen) {
            this.positions = new float[n * 2 + 2];
            this.maxPosLen = n;
        }
        if (this.maxLen == 0 || n > this.maxLen) {
            this.glyphData = new int[n];
            this.chData = new char[n];
            this.images = new long[n];
            this.maxLen = n;
        }
    }

    private GlyphList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphList getInstance() {
        if (inUse) {
            return new GlyphList();
        }
        Class<GlyphList> clazz = GlyphList.class;
        synchronized (GlyphList.class) {
            if (inUse) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new GlyphList();
            }
            inUse = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return reusableGL;
        }
    }

    public boolean setFromString(FontInfo fontInfo, String string, float f, float f2) {
        this.x = f;
        this.y = f2;
        this.strikelist = fontInfo.fontStrike;
        this.lcdRGBOrder = fontInfo.lcdRGBOrder;
        this.lcdSubPixPos = fontInfo.lcdSubPixPos;
        this.len = string.length();
        this.ensureCapacity(this.len);
        string.getChars(0, this.len, this.chData, 0);
        return this.mapChars(fontInfo, this.len);
    }

    public boolean setFromChars(FontInfo fontInfo, char[] cArray, int n, int n2, float f, float f2) {
        this.x = f;
        this.y = f2;
        this.strikelist = fontInfo.fontStrike;
        this.lcdRGBOrder = fontInfo.lcdRGBOrder;
        this.lcdSubPixPos = fontInfo.lcdSubPixPos;
        this.len = n2;
        this.len = n2 < 0 ? 0 : n2;
        this.ensureCapacity(this.len);
        System.arraycopy((Object)cArray, n, (Object)this.chData, 0, this.len);
        return this.mapChars(fontInfo, this.len);
    }

    private final boolean mapChars(FontInfo fontInfo, int n) {
        if (fontInfo.font2D.getMapper().charsToGlyphsNS(n, this.chData, this.glyphData)) {
            return false;
        }
        fontInfo.fontStrike.getGlyphImagePtrs(this.glyphData, this.images, n);
        this.glyphindex = -1;
        return true;
    }

    public void setFromGlyphVector(FontInfo fontInfo, GlyphVector glyphVector, float f, float f2) {
        this.x = f;
        this.y = f2;
        this.lcdRGBOrder = fontInfo.lcdRGBOrder;
        this.lcdSubPixPos = fontInfo.lcdSubPixPos;
        StandardGlyphVector standardGlyphVector = StandardGlyphVector.getStandardGV(glyphVector, fontInfo);
        this.usePositions = standardGlyphVector.needsPositions(fontInfo.devTx);
        this.len = standardGlyphVector.getNumGlyphs();
        this.ensureCapacity(this.len);
        this.strikelist = standardGlyphVector.setupGlyphImages(this.images, this.usePositions ? this.positions : null, fontInfo.devTx);
        this.glyphindex = -1;
    }

    public int[] getBounds() {
        if (this.glyphindex >= 0) {
            throw new InternalError("calling getBounds after setGlyphIndex");
        }
        if (this.metrics == null) {
            this.metrics = new int[5];
        }
        this.gposx = this.x + 0.5f;
        this.gposy = this.y + 0.5f;
        this.fillBounds(this.metrics);
        return this.metrics;
    }

    public void setGlyphIndex(int n) {
        this.glyphindex = n;
        if (this.images[n] == 0L) {
            this.metrics[0] = (int)this.gposx;
            this.metrics[1] = (int)this.gposy;
            this.metrics[2] = 0;
            this.metrics[3] = 0;
            this.metrics[4] = 0;
            return;
        }
        float f = StrikeCache.unsafe.getFloat(this.images[n] + (long)StrikeCache.topLeftXOffset);
        float f2 = StrikeCache.unsafe.getFloat(this.images[n] + (long)StrikeCache.topLeftYOffset);
        if (this.usePositions) {
            this.metrics[0] = (int)Math.floor(this.positions[n << 1] + this.gposx + f);
            this.metrics[1] = (int)Math.floor(this.positions[(n << 1) + 1] + this.gposy + f2);
        } else {
            this.metrics[0] = (int)Math.floor(this.gposx + f);
            this.metrics[1] = (int)Math.floor(this.gposy + f2);
            this.gposx += StrikeCache.unsafe.getFloat(this.images[n] + (long)StrikeCache.xAdvanceOffset);
            this.gposy += StrikeCache.unsafe.getFloat(this.images[n] + (long)StrikeCache.yAdvanceOffset);
        }
        this.metrics[2] = StrikeCache.unsafe.getChar(this.images[n] + (long)StrikeCache.widthOffset);
        this.metrics[3] = StrikeCache.unsafe.getChar(this.images[n] + (long)StrikeCache.heightOffset);
        this.metrics[4] = StrikeCache.unsafe.getChar(this.images[n] + (long)StrikeCache.rowBytesOffset);
    }

    public int[] getMetrics() {
        return this.metrics;
    }

    public byte[] getGrayBits() {
        int n = this.metrics[4] * this.metrics[3];
        if (this.graybits == null) {
            this.graybits = new byte[Math.max(n, 1024)];
        } else if (n > this.graybits.length) {
            this.graybits = new byte[n];
        }
        if (this.images[this.glyphindex] == 0L) {
            return this.graybits;
        }
        long l = StrikeCache.unsafe.getAddress(this.images[this.glyphindex] + (long)StrikeCache.pixelDataOffset);
        if (l == 0L) {
            return this.graybits;
        }
        for (int i = 0; i < n; ++i) {
            this.graybits[i] = StrikeCache.unsafe.getByte(l + (long)i);
        }
        return this.graybits;
    }

    public long[] getImages() {
        return this.images;
    }

    public boolean usePositions() {
        return this.usePositions;
    }

    public float[] getPositions() {
        return this.positions;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Object getStrike() {
        return this.strikelist;
    }

    public boolean isSubPixPos() {
        return this.lcdSubPixPos;
    }

    public boolean isRGBOrder() {
        return this.lcdRGBOrder;
    }

    public void dispose() {
        if (this == reusableGL) {
            if (this.graybits != null && this.graybits.length > 8192) {
                this.graybits = null;
            }
            this.usePositions = false;
            this.strikelist = null;
            inUse = false;
        }
    }

    public int getNumGlyphs() {
        return this.len;
    }

    private void fillBounds(int[] nArray) {
        int n = StrikeCache.topLeftXOffset;
        int n2 = StrikeCache.topLeftYOffset;
        int n3 = StrikeCache.widthOffset;
        int n4 = StrikeCache.heightOffset;
        int n5 = StrikeCache.xAdvanceOffset;
        int n6 = StrikeCache.yAdvanceOffset;
        if (this.len == 0) {
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
            return;
        }
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        int n7 = 0;
        float f5 = this.x + 0.5f;
        float f6 = this.y + 0.5f;
        for (int i = 0; i < this.len; ++i) {
            float f7;
            float f8;
            if (this.images[i] == 0L) continue;
            float f9 = StrikeCache.unsafe.getFloat(this.images[i] + (long)n);
            float f10 = StrikeCache.unsafe.getFloat(this.images[i] + (long)n2);
            char c = StrikeCache.unsafe.getChar(this.images[i] + (long)n3);
            char c2 = StrikeCache.unsafe.getChar(this.images[i] + (long)n4);
            if (this.usePositions) {
                f8 = this.positions[n7++] + f9 + f5;
                f7 = this.positions[n7++] + f10 + f6;
            } else {
                f8 = f5 + f9;
                f7 = f6 + f10;
                f5 += StrikeCache.unsafe.getFloat(this.images[i] + (long)n5);
                f6 += StrikeCache.unsafe.getFloat(this.images[i] + (long)n6);
            }
            float f11 = f8 + (float)c;
            float f12 = f7 + (float)c2;
            if (f2 > f8) {
                f2 = f8;
            }
            if (f > f7) {
                f = f7;
            }
            if (f4 < f11) {
                f4 = f11;
            }
            if (!(f3 < f12)) continue;
            f3 = f12;
        }
        nArray[0] = (int)Math.floor(f2);
        nArray[1] = (int)Math.floor(f);
        nArray[2] = (int)Math.floor(f4);
        nArray[3] = (int)Math.floor(f3);
    }
}

