/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.vm.VM;
import java.io.IOException;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.Attachment;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

final class WaitLoop
extends Thread {
    WaitLoop() {
        this.setDaemon(true);
        this.setName("Attach API wait loop");
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attachment waitForNotification(boolean bl) throws IOException {
        Object object = AttachHandler.mainHandler.getIgnoreNotification();
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entering");
        }
        Object object2 = object;
        synchronized (object2) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entered");
            }
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification starting wait");
        }
        int n = 0;
        if (AttachHandler.startWaitingForSemaphore()) {
            n = CommonDirectory.waitSemaphore(AttachHandler.vmId);
            AttachHandler.endWaitingForSemaphore();
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ended wait");
        }
        if (AttachHandler.isAttachApiTerminated()) {
            if (AttachHandler.getDoCancelNotify()) {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification cancelNotify");
                }
                CommonDirectory.cancelNotify(AttachHandler.getNumberOfTargets(), true);
            }
            return null;
        }
        if (n != 0) {
            if (bl) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification reopen semaphore");
                AttachHandler.AttachStateSync attachStateSync = AttachHandler.stateSync;
                synchronized (attachStateSync) {
                    if (!AttachHandler.isAttachApiTerminated()) {
                        try {
                            CommonDirectory.obtainControllerLock("WaitLoop.waitForNotification(" + bl + ")_1");
                            n = CommonDirectory.reopenSemaphore();
                            CommonDirectory.releaseControllerLock("WaitLoop.waitForNotification(" + bl + ")_2");
                        }
                        catch (IOException iOException) {
                            IPC.logMessage("waitForNotification: IOError on controller lock : ", iOException.toString());
                        }
                    }
                }
                if (0 == n && TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
                    if (CommonDirectory.tryObtainControllerLock("WaitLoop.waitForNotification(" + bl + ")_3")) {
                        IPC.logMessage("semaphore recovery: send test post");
                        int n2 = CommonDirectory.countTargetDirectories();
                        AttachHandler.setNumberOfTargets(n2);
                        CommonDirectory.notifyVm(n2, true, "WaitLoop.waitForNotification");
                        CommonDirectory.releaseControllerLock("WaitLoop.waitForNotification(" + bl + ")_4");
                    }
                    return this.waitForNotification(false);
                }
            }
            AttachHandler.mainHandler.terminate(false);
            return null;
        }
        Attachment attachment = WaitLoop.checkReplyAndCreateAttachment();
        return attachment;
    }

    private static Attachment checkReplyAndCreateAttachment() throws IOException {
        Attachment attachment = AttachHandler.mainHandler.connectToAttacher();
        if (!TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
            AttachHandler.mainHandler.terminate(false);
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("checkReplyAndCreateAttachment iteration " + AttachHandler.notificationCount + " waitForNotification obtainLock");
        }
        if (!AttachHandler.mainHandler.syncFileLock.lockFile(true, "WaitLoop.checkReplyAndCreateAttachment")) {
            TargetDirectory.createMySyncFile();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " checkReplyAndCreateAttachment releaseLock");
            }
            AttachHandler.mainHandler.syncFileLock.unlockFile("WaitLoop.checkReplyAndCreateAttachment");
        }
        try {
            IPC.logMessage("WaitLoop.checkReplyAndCreateAttachment before sleep");
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            IPC.logMessage("WaitLoop.checkReplyAndCreateAttachment Interrupted");
            return attachment;
        }
        return attachment;
    }

    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        while (!AttachHandler.isAttachApiTerminated()) {
            try {
                this.waitForNotification(true);
            }
            catch (IOException iOException) {
                IPC.logMessage("WaitLoop.waitForNotification exception: AttachHandler.notificationCount = " + AttachHandler.notificationCount, iOException.toString());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IPC.tracepoint(-2, outOfMemoryError.getMessage());
                try {
                    IPC.logMessage("WaitLoop.waitForNotification OutOfMemoryError before sleep");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    IPC.logMessage("WaitLoop.waitForNotification OutOfMemoryError Interrupted");
                    continue;
                }
            }
            ++AttachHandler.notificationCount;
        }
        AttachHandler.mainHandler.syncFileLock = null;
    }
}

