/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.TimerTask;
import openj9.internal.tools.attach.target.FilelockTimer;
import openj9.internal.tools.attach.target.IPC;

public final class FileLock {
    long fileDescriptor;
    String lockFilepath;
    int fileMode;
    private boolean locked = false;
    private static FilelockTimer fileLockWatchdogTimer;
    private static syncObject shutdownSync;
    static boolean terminated;
    private volatile java.nio.channels.FileLock lockObject;
    private volatile RandomAccessFile lockFileRAF;

    boolean isLocked() {
        return this.locked;
    }

    public FileLock(String string, int n) {
        if (null == string) {
            throw new NullPointerException("filePath is null");
        }
        this.lockFilepath = string;
        this.fileMode = n;
        this.lockObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockFile(boolean bl, String string) throws IOException {
        String string2 = bl ? "locking file " : "non-blocking locking file ";
        IPC.logMessage(string + " : " + string2, this.lockFilepath);
        if (this.locked) {
            throw new IOException(Msg.getString("K0574"));
        }
        this.fileDescriptor = FileLock.lockFileImpl(this.lockFilepath, this.fileMode, false);
        boolean bl2 = this.locked = 0L <= this.fileDescriptor;
        if (!this.locked && bl) {
            FileLockWatchdogTask fileLockWatchdogTask = new FileLockWatchdogTask();
            IPC.logMessage("lock failed, trying blocking lock");
            Object object = shutdownSync;
            synchronized (object) {
                if (!terminated && null == fileLockWatchdogTimer) {
                    fileLockWatchdogTimer = new FilelockTimer("file lock watchdog");
                }
                if (null == fileLockWatchdogTimer) {
                    IPC.logMessage("FileLock.lockFile() returns false.");
                    return false;
                }
                IPC.logMessage("FileLock.lockFile() FILE_LOCK_TIMEOUT = 20000", new Throwable(""));
                fileLockWatchdogTimer.schedule((TimerTask)fileLockWatchdogTask, 20000L);
            }
            try {
                IPC.logMessage("FileLock.lockFile() before RandomAccessFile creation");
                this.lockFileRAF = new RandomAccessFile(this.lockFilepath, "rw");
                object = this.lockFileRAF.getChannel();
                IPC.logMessage("FileLock.lockFile() before lockFileChannel.lock()");
                this.lockObject = ((FileChannel)object).lock();
                IPC.logMessage("FileLock.lockFile() blocking lock succeeded");
                this.locked = true;
            }
            catch (IOException iOException) {
                this.locked = false;
                IPC.logMessage("FileLock.lockFile() blocking lock failed with lockFilepath = " + this.lockFilepath);
            }
            object = shutdownSync;
            synchronized (object) {
                if (null != fileLockWatchdogTimer) {
                    fileLockWatchdogTask.cancel();
                }
            }
        }
        IPC.logMessage("FileLock.lockFile() locking file succeeded, locked = " + this.locked);
        return this.locked;
    }

    public void unlockFile(String string) {
        RandomAccessFile randomAccessFile;
        IPC.logMessage(string + "_unlockFile() ", this.lockFilepath);
        java.nio.channels.FileLock fileLock = this.lockObject;
        if (null != fileLock) {
            IPC.logMessage("FileLock.unlockFile closing lockObjectCopy ", this.lockFilepath);
            try {
                fileLock.release();
            }
            catch (IOException iOException) {
                IPC.logMessage("IOException at lockObjectCopy.release() with lockFilepath = " + this.lockFilepath, iOException);
            }
        }
        if ((randomAccessFile = this.lockFileRAF) != null) {
            IPC.logMessage("FileLock.unlockFile closing lockFileRAFCopy ", this.lockFilepath);
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                IPC.logMessage("IOException at lockFileRAFCopy.close() with lockFilepath = " + this.lockFilepath, iOException);
            }
        }
        if (this.locked && this.fileDescriptor >= 0L) {
            IPC.logMessage(string + "_unlockFile : unlockFileImpl fileDescriptor " + this.fileDescriptor);
            FileLock.unlockFileImpl(this.fileDescriptor);
        }
        this.locked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDown() {
        syncObject syncObject2 = shutdownSync;
        synchronized (syncObject2) {
            terminated = true;
            if (null != fileLockWatchdogTimer) {
                fileLockWatchdogTimer.cancel();
                fileLockWatchdogTimer.purge();
            }
            fileLockWatchdogTimer = null;
        }
    }

    private static native long lockFileImpl(String var0, int var1, boolean var2);

    private static native int unlockFileImpl(long var0);

    static {
        shutdownSync = new syncObject();
    }

    final class FileLockWatchdogTask
    extends TimerTask {
        FileLockWatchdogTask() {
        }

        @Override
        public void run() {
            IPC.logMessage("waitAndCheckLock recreating ", FileLock.this.lockFilepath);
            File file = new File(FileLock.this.lockFilepath);
            if (!file.renameTo(new File(file.getParent(), ".trash_" + IPC.getRandomNumber()))) {
                IPC.logMessage("waitAndCheckLock could not rename ", file.getName());
                file.renameTo(new File(file.getParent(), ".trash_" + IPC.getRandomNumber()));
            }
            FileLock.this.unlockFile("FileLock.FileLockWatchdogTask");
            if (!file.delete()) {
                IPC.logMessage("waitAndCheckLock could not delete ", file.getAbsolutePath());
            } else {
                IPC.logMessage("waitAndCheckLock deleted ", file.getAbsolutePath());
            }
            IPC.logMessage("waitAndCheckLock normal return ");
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

