/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class ObjectView
extends ComponentView {
    public ObjectView(Element element) {
        super(element);
    }

    @Override
    protected Component createComponent() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.CLASSID);
        try {
            ReflectUtil.checkPackageAccess(string);
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            Object obj = clazz.newInstance();
            if (obj instanceof Component) {
                Component component = (Component)obj;
                this.setParameters(component, attributeSet);
                return component;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getUnloadableRepresentation();
    }

    Component getUnloadableRepresentation() {
        JLabel jLabel = new JLabel("??");
        ((Component)jLabel).setForeground(Color.red);
        return jLabel;
    }

    private void setParameters(Component component, AttributeSet attributeSet) {
        BeanInfo beanInfo;
        Class<? extends Object> clazz = component.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("introspector failed, ex: " + introspectionException);
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Object object = attributeSet.getAttribute(propertyDescriptorArray[i].getName());
            if (!(object instanceof String)) continue;
            String string = (String)object;
            Method method = propertyDescriptorArray[i].getWriteMethod();
            if (method == null) {
                return;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return;
            }
            Object[] objectArray = new Object[]{string};
            try {
                MethodUtil.invoke(method, component, objectArray);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invocation failed");
            }
        }
    }
}

