/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private transient Object walkback;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;
    private static final Throwable[] ZeroElementArray = new Throwable[0];
    private static final StackTraceElement[] ZeroStackTraceElementArray = new StackTraceElement[0];
    private List<Throwable> suppressedExceptions = Collections.EMPTY_LIST;
    private transient boolean disableWritableStackTrace;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String string) {
        this();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this();
        this.detailMessage = string;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    protected Throwable(String string, Throwable throwable, boolean bl, boolean bl2) {
        this.detailMessage = string;
        this.cause = throwable;
        if (!bl) {
            this.suppressedExceptions = null;
        }
        if (!bl2) {
            this.disableWritableStackTrace = true;
        } else {
            this.fillInStackTrace();
        }
    }

    public native Throwable fillInStackTrace();

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null) {
            throw new NullPointerException();
        }
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i] != null) continue;
            throw new NullPointerException();
        }
        if (this.disableWritableStackTrace) {
            return;
        }
        this.stackTrace = stackTraceElementArray2;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement stackTraceElement;
        int n = 0;
        int n2 = stackTraceElementArray2.length;
        int n3 = stackTraceElementArray.length;
        while (--n3 >= 0 && --n2 >= 0 && (stackTraceElement = stackTraceElementArray2[n2]).equals(stackTraceElementArray[n3])) {
            ++n;
        }
        return n;
    }

    StackTraceElement[] getInternalStackTrace() {
        if (this.disableWritableStackTrace) {
            return ZeroStackTraceElementArray;
        }
        StackTraceElement[] stackTraceElementArray = this.stackTrace;
        if (stackTraceElementArray == null) {
            stackTraceElementArray = J9VMInternals.getStackTrace(this, true);
            this.stackTrace = stackTraceElementArray;
        }
        return stackTraceElementArray;
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTraceHelper(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.printStackTraceHelper(printWriter);
    }

    private void printStackTraceHelper(Appendable appendable) {
        Set<Throwable> set = null;
        try {
            set = Collections.newSetFromMap(new IdentityHashMap());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        StackTraceElement[] stackTraceElementArray = this.printStackTrace(appendable, null, 0, false, set);
        for (Throwable throwable = this.getCause(); throwable != null && stackTraceElementArray != null; throwable = throwable.getCause()) {
            stackTraceElementArray = throwable.printStackTrace(appendable, stackTraceElementArray, 0, false, set);
        }
    }

    public String toString() {
        String string = this.getLocalizedMessage();
        String string2 = this.getClass().getName();
        if (string == null) {
            return string2;
        }
        int n = string2.length() + 2 + string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        return stringBuilder.append(string2).append(": ").append(string).toString();
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException(Msg.getString("K05c9"));
        }
        if (throwable == this) {
            throw new IllegalArgumentException(Msg.getString("K05c8"));
        }
        return this.setCause(throwable);
    }

    Throwable setCause(Throwable throwable) {
        this.cause = throwable;
        return this;
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getInternalStackTrace();
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block15: {
            objectInputStream.defaultReadObject();
            boolean bl = this.disableWritableStackTrace = this.stackTrace == null;
            if (this.stackTrace != null) {
                if (this.stackTrace.length == 1) {
                    if (this.stackTrace[0] == null) {
                        throw new NullPointerException(Msg.getString("K0560"));
                    }
                    if (this.stackTrace[0].equals(new StackTraceElement("", "", null, Integer.MIN_VALUE))) {
                        this.stackTrace = null;
                    }
                } else {
                    for (int i = 0; i < this.stackTrace.length; ++i) {
                        if (this.stackTrace[i] != null) continue;
                        throw new NullPointerException(Msg.getString("K0560"));
                    }
                }
            }
            if (this.suppressedExceptions != null) {
                ArrayList<Throwable> arrayList = Collections.EMPTY_LIST;
                try {
                    ClassLoader classLoader = this.suppressedExceptions.getClass().getClassLoader();
                    if (classLoader == null) {
                        int n = this.suppressedExceptions.size();
                        if (n != 0) {
                            arrayList = new ArrayList<Throwable>(n);
                            for (Throwable throwable : this.suppressedExceptions) {
                                if (throwable == null) {
                                    throw new NullPointerException(Msg.getString("K0561"));
                                }
                                if (throwable == this) {
                                    throw new IllegalArgumentException(Msg.getString("K0562"));
                                }
                                arrayList.add(throwable);
                            }
                        }
                        break block15;
                    }
                    throw new StreamCorruptedException(Msg.getString("K0C00"));
                }
                finally {
                    this.suppressedExceptions = arrayList;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackTraceElement[] printStackTrace(Appendable appendable, StackTraceElement[] stackTraceElementArray, int n, boolean bl, Set<Throwable> set) {
        StackTraceElement[] stackTraceElementArray2;
        if (appendable == null) {
            throw new NullPointerException();
        }
        boolean bl2 = this instanceof OutOfMemoryError;
        if (set != null && set.contains(this)) {
            if (!bl2) {
                try {
                    Util.appendTo(appendable, "\t[CIRCULAR REFERENCE:" + this.toString() + "]", 0);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Util.appendTo(appendable, "\t[CIRCULAR REFERENCE:");
                try {
                    Util.appendTo(appendable, this.getClass().getName());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Util.appendTo(appendable, "java.lang.OutOfMemoryError(?)");
                }
                Util.appendTo(appendable, "]");
            }
            Util.appendLnTo(appendable);
            return null;
        }
        try {
            set.add(this);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (stackTraceElementArray != null) {
            if (bl) {
                Util.appendTo(appendable, "Suppressed: ", n);
            } else {
                Util.appendTo(appendable, "Caused by: ", n);
            }
        }
        if (!bl2) {
            try {
                Util.appendTo(appendable, this.toString());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bl2 = true;
            }
        }
        if (bl2) {
            try {
                Util.appendTo(appendable, this.getClass().getName());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bl2 = true;
                Util.appendTo(appendable, "java.lang.OutOfMemoryError(?)");
            }
            try {
                String string = this.getLocalizedMessage();
                if (string != null) {
                    Util.appendTo(appendable, ": ");
                    Util.appendTo(appendable, string);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bl2 = true;
            }
        }
        Util.appendLnTo(appendable);
        int n2 = 0;
        try {
            stackTraceElementArray2 = this.getInternalStackTrace();
            if (stackTraceElementArray != null) {
                n2 = Throwable.countDuplicates(stackTraceElementArray2, stackTraceElementArray);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Util.appendTo(appendable, "\tat ?", n);
            Util.appendLnTo(appendable);
            return null;
        }
        for (int i = 0; i < stackTraceElementArray2.length - n2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            if (!bl2) {
                try {
                    Util.appendTo(appendable, "\tat " + stackTraceElement, n);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Util.appendTo(appendable, "\tat ", n);
                Util.printStackTraceElement(stackTraceElement, null, appendable, false);
            }
            Util.appendLnTo(appendable);
        }
        if (n2 > 0) {
            if (!bl2) {
                try {
                    Util.appendTo(appendable, "\t... " + n2 + " more", n);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Util.appendTo(appendable, "\t... ", n);
                Util.appendTo(appendable, n2);
                Util.appendTo(appendable, " more");
            }
            Util.appendLnTo(appendable);
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions != null) {
                for (Throwable throwable2 : this.suppressedExceptions) {
                    StackTraceElement[] stackTraceElementArray3 = throwable2.printStackTrace(appendable, stackTraceElementArray2, n + 1, true, set);
                    for (Throwable throwable3 = throwable2.getCause(); throwable3 != null && stackTraceElementArray3 != null; throwable3 = throwable3.getCause()) {
                        stackTraceElementArray3 = throwable3.printStackTrace(appendable, stackTraceElementArray3, n + 1, false, set);
                    }
                }
            }
        }
        return stackTraceElementArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSuppressed(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException(Msg.getString("K0563"));
        }
        if (throwable == this) {
            throw new IllegalArgumentException(Msg.getString("K0559"));
        }
        Throwable throwable2 = this;
        synchronized (throwable2) {
            if (this.suppressedExceptions != null) {
                if (this.suppressedExceptions.size() == 0) {
                    this.suppressedExceptions = new ArrayList<Throwable>(2);
                }
                this.suppressedExceptions.add(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable[] getSuppressed() {
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions == null || this.suppressedExceptions.size() == 0) {
                return ZeroElementArray;
            }
            return this.suppressedExceptions.toArray(new Throwable[this.suppressedExceptions.size()]);
        }
    }
}

