/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.RuntimePermissions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import jdk.internal.util.StaticProperty;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.misc.Version;
import sun.reflect.CallerSensitive;
import sun.security.util.SecurityConstants;

public final class System {
    public static final InputStream in = null;
    public static final PrintStream out = null;
    public static final PrintStream err = null;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static Properties systemProperties;
    private static SecurityManager security;
    private static volatile Console console;
    private static volatile boolean consoleInitialized;
    private static String lineSeparator;
    private static boolean propertiesInitialized;
    private static String platformEncoding;
    private static String fileEncoding;
    private static String osEncoding;
    private static final int sysPropID_PlatformEncoding = 1;
    private static final int sysPropID_FileEncoding = 2;
    private static final int sysPropID_OSEncoding = 3;

    private static String getCharsetName(String string, Charset charset) {
        if (string != null) {
            try {
                Charset charset2 = Charset.forName(string);
                if (charset2.equals(charset)) {
                    return null;
                }
                return charset2.name();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static PrintStream createConsole(FileDescriptor fileDescriptor, String string) {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(fileDescriptor));
        if (string == null) {
            return new PrintStream(bufferedOutputStream, true);
        }
        try {
            return new PrintStream(bufferedOutputStream, true, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("For encoding " + string, unsupportedEncodingException);
        }
    }

    static void afterClinitInitialization() {
        Object object;
        Object object2;
        Object object3;
        if (null == com.ibm.oti.vm.VM.getVMLangAccess()) {
            com.ibm.oti.vm.VM.setVMLangAccess(new VMAccess());
        }
        System.ensureProperties(true);
        SharedSecrets.setJavaLangAccess(new Access());
        try {
            object3 = J9VMInternals.class.getDeclaredField("jitHelpers");
            object2 = String.class.getDeclaredField("helpers");
            object = Unsafe.getUnsafe();
            ((Unsafe)object).putObject(((Unsafe)object).staticFieldBase((Field)object3), ((Unsafe)object).staticFieldOffset((Field)object3), (Object)JITHelpers.getHelpers());
            ((Unsafe)object).putObject(((Unsafe)object).staticFieldBase((Field)object2), ((Unsafe)object).staticFieldOffset((Field)object2), (Object)JITHelpers.getHelpers());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        object3 = System.internalGetProperties().getProperty("java.lang.string.substring.nocopy");
        String.enableSharingInSubstringWhenOffsetIsZero = object3 == null || ((String)object3).equalsIgnoreCase("false");
        StringCoding.encode(new char[1], 0, 1);
        object2 = System.internalGetProperties();
        object = Charset.defaultCharset();
        String string = System.getCharsetName(((Properties)object2).getProperty("sun.stdout.encoding"), (Charset)object);
        String string2 = System.getCharsetName(((Properties)object2).getProperty("sun.stderr.encoding"), (Charset)object);
        System.setErr(System.createConsole(FileDescriptor.err, string2));
        System.setOut(System.createConsole(FileDescriptor.out, string));
    }

    static native void startSNMPAgent();

    static void completeInitialization() {
        System.setIn(new BufferedInputStream(new FileInputStream(FileDescriptor.in)));
        Terminator.setup();
    }

    public static void setIn(InputStream inputStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermissions.permissionSetIO);
        }
        System.setFieldImpl("in", inputStream);
    }

    public static void setOut(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermissions.permissionSetIO);
        }
        System.setFieldImpl("out", printStream);
    }

    public static void setErr(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermissions.permissionSetIO);
        }
        System.setFieldImpl("err", printStream);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        if (objectArray == null || objectArray2 == null) {
            throw new NullPointerException();
        }
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n3 <= objectArray.length - n && n3 <= objectArray2.length - n2) {
            if (objectArray != objectArray2 || n > n2 || n + n3 <= n2) {
                for (int i = 0; i < n3; ++i) {
                    objectArray2[n2 + i] = objectArray[n + i];
                }
            } else {
                for (int i = n3 - 1; i >= 0; --i) {
                    objectArray2[n2 + i] = objectArray[n + i];
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties(boolean bl) {
        String string;
        Properties properties = new Properties();
        if (osEncoding != null) {
            properties.put("os.encoding", osEncoding);
        }
        properties.put("ibm.system.encoding", platformEncoding);
        properties.put("sun.jnu.encoding", platformEncoding);
        properties.put("file.encoding.pkg", "sun.io");
        properties.put("java.specification.vendor", "Oracle Corporation");
        properties.put("java.specification.name", "Java Platform API Specification");
        properties.put("com.ibm.oti.configuration", "scar");
        String[] stringArray = System.getPropertyList();
        for (int i = 0; i < stringArray.length && (string = stringArray[i]) != null; i += 2) {
            properties.put(string, stringArray[i + 1]);
        }
        properties.put("file.encoding", fileEncoding);
        propertiesInitialized = true;
        systemProperties = properties;
        Version.init();
        StringBuffer.initFromSystemProperties(systemProperties);
        StringBuilder.initFromSystemProperties(systemProperties);
        String string2 = properties.getProperty("java.runtime.version");
        if (null != string2) {
            string = properties.getProperty("java.fullversion");
            if (null != string) {
                properties.put("java.fullversion", string2 + "\n" + string);
            }
            System.rasInitializeVersion(string2);
        }
        lineSeparator = properties.getProperty("line.separator", "\n");
        if (bl) {
            VM.saveAndRemoveProperties(properties);
        }
        systemProperties = properties;
        StaticProperty.jdkSerialFilter();
    }

    private static void initializeSystemProperties(Map<String, String> map) {
        systemProperties = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            systemProperties.put(entry.getKey(), entry.getValue());
        }
    }

    private static native void rasInitializeVersion(String var0);

    public static void exit(int n) {
        RUNTIME.exit(n);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static String getenv(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return ProcessEnvironment.getenv(string);
    }

    public static Properties getProperties() {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return systemProperties;
    }

    static Properties internalGetProperties() {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init");
        }
        return systemProperties;
    }

    public static String getProperty(String string) {
        return System.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        if (!(propertiesInitialized || string.equals("com.ibm.IgnoreMalformedInput") || string.equals("file.encoding.pkg") || string.equals("sun.nio.cs.map"))) {
            if (string.equals("os.encoding")) {
                return osEncoding;
            }
            if (string.equals("ibm.system.encoding")) {
                return platformEncoding;
            }
            if (string.equals("file.encoding")) {
                return fileEncoding;
            }
            throw new Error("bootstrap error, system property access before init: " + string);
        }
        return systemProperties.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init: " + string);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)systemProperties.setProperty(string, string2);
    }

    private static native String[] getPropertyList();

    private static native String getSysPropBeforePropertiesInitialized(int var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static int identityHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return J9VMInternals.fastIdentityHashCode(object);
    }

    @CallerSensitive
    public static void load(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        ClassLoader.loadLibraryWithPath(string, ClassLoader.callerClassLoader(), null);
    }

    @CallerSensitive
    public static void loadLibrary(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        ClassLoader.loadLibraryWithClassLoader(string, ClassLoader.callerClassLoader());
    }

    public static void runFinalization() {
        RUNTIME.runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean bl) {
        Runtime.runFinalizersOnExit(bl);
    }

    public static void setProperties(Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (properties == null) {
            System.ensureProperties(false);
        } else {
            systemProperties = properties;
        }
    }

    static void initSecurityManager(ClassLoader classLoader) {
        String string = System.internalGetProperties().getProperty("java.security.manager");
        if (null != string) {
            if (string.isEmpty() || "default".equals(string)) {
                System.setSecurityManager(new SecurityManager());
            } else {
                try {
                    Constructor<?> constructor = Class.forName(string, true, classLoader).getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    System.setSecurityManager((SecurityManager)constructor.newInstance(new Object[0]));
                }
                catch (Throwable throwable) {
                    throw new Error(Msg.getString("K0631", throwable.toString()), throwable);
                }
            }
        }
    }

    public static void setSecurityManager(final SecurityManager securityManager) {
        final SecurityManager securityManager2 = security;
        if (securityManager != null) {
            if (securityManager2 == null) {
                try {
                    securityManager.checkPackageAccess("java.lang");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ProtectionDomain protectionDomain;
                        if (securityManager2 == null) {
                            Msg.getString("K002c");
                        }
                        if ((protectionDomain = securityManager.getClass().getPDImpl()) != null) {
                            protectionDomain.implies(SecurityConstants.ALL_PERMISSION);
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (securityManager2 != null) {
            securityManager2.checkPermission(RuntimePermissions.permissionSetSecurityManager);
        }
        security = securityManager;
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, Object var1);

    @CallerSensitive
    static Class getCallerClass() {
        return Class.getStackClass(2);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    public static native long nanoTime();

    public static String clearProperty(String string) {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init: " + string);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)systemProperties.remove(string);
    }

    public static Map<String, String> getenv() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Console console() {
        if (consoleInitialized) {
            return console;
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (consoleInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return console;
            }
            console = SharedSecrets.getJavaIOAccess().console();
            consoleInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return console;
        }
    }

    private static void longMultiLeafArrayCopy(Object object, int n, Object object2, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = object != object2 || n > n2 || n + n3 <= n2;
        int n10 = n5 / n4;
        if (bl) {
            n9 = n;
            n8 = n2;
        } else {
            n9 = n + n3 - 1;
            n8 = n2 + n3 - 1;
        }
        int n11 = n9 % n10;
        int n12 = n8 % n10;
        if (n11 < n12) {
            if (bl) {
                n7 = n10 - n12;
                n6 = n10 - (n11 + n7);
            } else {
                n7 = n11 + 1;
                n6 = n12 - n11;
            }
        } else if (bl) {
            n7 = n10 - n11;
            n6 = n10 - (n12 + n7);
        } else {
            n7 = n12 + 1;
            n6 = n11 - n12;
        }
        int n13 = n10 - n6;
        int n14 = bl ? 0 : n7 - 1;
        System.arraycopy(object, n9 - n14, object2, n8 - n14, n7);
        n9 = bl ? n9 + n7 : n9 - n7;
        n8 = bl ? n8 + n7 : n8 - n7;
        n3 -= n7;
        while (n3 >= n10) {
            n14 = bl ? 0 : n6 - 1;
            System.arraycopy(object, n9 - n14, object2, n8 - n14, n6);
            n9 = bl ? n9 + n6 : n9 - n6;
            n8 = bl ? n8 + n6 : n8 - n6;
            n14 = bl ? 0 : n13 - 1;
            System.arraycopy(object, n9 - n14, object2, n8 - n14, n13);
            n9 = bl ? n9 + n13 : n9 - n13;
            n8 = bl ? n8 + n13 : n8 - n13;
            n3 -= n10;
        }
        if (n3 > n6) {
            n14 = bl ? 0 : n6 - 1;
            System.arraycopy(object, n9 - n14, object2, n8 - n14, n6);
            n9 = bl ? n9 + n6 : n9 - n6;
            n8 = bl ? n8 + n6 : n8 - n6;
            n3 -= n6;
        }
        if (n3 > 0) {
            n14 = bl ? 0 : n3 - 1;
            System.arraycopy(object, n9 - n14, object2, n8 - n14, n3);
        }
    }

    private static void simpleMultiLeafArrayCopy(Object object, int n, Object object2, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        boolean bl = object != object2 || n > n2 || n + n3 <= n2;
        int n10 = n5 / n4;
        if (bl) {
            n8 = n;
            n7 = n2;
        } else {
            n8 = n + n3 - 1;
            n7 = n2 + n3 - 1;
        }
        for (n9 = 0; n9 < n3; n9 += n6) {
            int n11 = n8 % n10;
            int n12 = n7 % n10;
            n6 = bl && n11 >= n12 || !bl && n11 < n12 ? (bl ? n10 - n11 : n11 + 1) : (bl ? n10 - n12 : n12 + 1);
            if (n3 - n9 < n6) {
                n6 = n3 - n9;
            }
            int n13 = bl ? 0 : n6 - 1;
            System.arraycopy(object, n8 - n13, object2, n7 - n13, n6);
            if (bl) {
                n8 += n6;
                n7 += n6;
                continue;
            }
            n8 -= n6;
            n7 -= n6;
        }
    }

    private static void multiLeafArrayCopy(Object object, int n, Object object2, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8 = 0;
        boolean bl = object != object2 || n > n2 || n + n3 <= n2;
        int n9 = n5 / n4;
        if (bl) {
            n7 = n;
            n6 = n2;
        } else {
            n7 = n + n3 - 1;
            n6 = n2 + n3 - 1;
        }
        int n10 = 0;
        int n11 = 0;
        while (n8 < n3) {
            int n12;
            int n13;
            int n14 = n7 % n9;
            int n15 = n6 % n9;
            if (bl && n14 >= n15 || !bl && n14 < n15) {
                n13 = n14;
                n12 = n6;
            } else {
                n13 = n15;
                n12 = n7;
            }
            int n16 = 0;
            n10 = bl ? n9 - n13 : n13 + 1;
            if (n3 - n8 < n10) {
                n10 = n3 - n8;
            }
            if (bl) {
                n11 = n9 - (n12 + n10) % n9;
            } else {
                n11 = (n12 - n10) % n9 + 1;
                n16 = n10 - 1;
            }
            if (n3 - n8 - n10 < n11) {
                n11 = n3 - n8 - n10;
            }
            System.arraycopy(object, n7 - n16, object2, n6 - n16, n10);
            n16 = 0;
            if (bl) {
                n7 += n10;
                n6 += n10;
            } else {
                n7 -= n10;
                n6 -= n10;
                n16 = n11 - 1;
            }
            if (n11 <= 0) break;
            System.arraycopy(object, n7 - n16, object2, n6 - n16, n11);
            if (bl) {
                n7 += n11;
                n6 += n11;
            } else {
                n7 -= n11;
                n6 -= n11;
            }
            n8 += n10 + n11;
        }
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    static {
        platformEncoding = System.getSysPropBeforePropertiesInitialized(1);
        String string = System.getSysPropBeforePropertiesInitialized(3);
        String string2 = System.getSysPropBeforePropertiesInitialized(2);
        if (string2 != null) {
            fileEncoding = string2;
            if (string == null) {
                osEncoding = platformEncoding;
            }
        } else {
            fileEncoding = platformEncoding;
        }
        if (osEncoding == null) {
            osEncoding = string;
        }
    }
}

