/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import sun.awt.geom.Curve;

public abstract class Path2D
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    transient byte[] pointTypes;
    transient int numTypes;
    transient int numCoords;
    transient int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    static final int EXPAND_MAX_COORDS = 1000;
    static final int EXPAND_MIN = 10;
    private static final byte SERIAL_STORAGE_FLT_ARRAY = 48;
    private static final byte SERIAL_STORAGE_DBL_ARRAY = 49;
    private static final byte SERIAL_SEG_FLT_MOVETO = 64;
    private static final byte SERIAL_SEG_FLT_LINETO = 65;
    private static final byte SERIAL_SEG_FLT_QUADTO = 66;
    private static final byte SERIAL_SEG_FLT_CUBICTO = 67;
    private static final byte SERIAL_SEG_DBL_MOVETO = 80;
    private static final byte SERIAL_SEG_DBL_LINETO = 81;
    private static final byte SERIAL_SEG_DBL_QUADTO = 82;
    private static final byte SERIAL_SEG_DBL_CUBICTO = 83;
    private static final byte SERIAL_SEG_CLOSE = 96;
    private static final byte SERIAL_PATH_END = 97;

    Path2D() {
    }

    Path2D(int n, int n2) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
    }

    abstract float[] cloneCoordsFloat(AffineTransform var1);

    abstract double[] cloneCoordsDouble(AffineTransform var1);

    abstract void append(float var1, float var2);

    abstract void append(double var1, double var3);

    abstract Point2D getPoint(int var1);

    abstract void needRoom(boolean var1, int var2);

    abstract int pointCrossings(double var1, double var3);

    abstract int rectCrossings(double var1, double var3, double var5, double var7);

    static byte[] expandPointTypes(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = n2 + n;
        if (n3 < n2) {
            throw new ArrayIndexOutOfBoundsException("pointTypes exceeds maximum capacity !");
        }
        int n4 = n2;
        if (n4 > 500) {
            n4 = Math.max(500, n2 >> 3);
        } else if (n4 < 10) {
            n4 = 10;
        }
        assert (n4 > 0);
        int n5 = n2 + n4;
        if (n5 < n3) {
            n5 = Integer.MAX_VALUE;
        }
        while (true) {
            try {
                return Arrays.copyOf(byArray, n5);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (n5 == n3) {
                    throw outOfMemoryError;
                }
                n5 = n3 + (n5 - n3) / 2;
                continue;
            }
            break;
        }
    }

    public abstract void moveTo(double var1, double var3);

    public abstract void lineTo(double var1, double var3);

    public abstract void quadTo(double var1, double var3, double var5, double var7);

    public abstract void curveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    public final synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public final void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(null), bl);
    }

    public abstract void append(PathIterator var1, boolean var2);

    public final synchronized int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final synchronized Point2D getCurrentPoint() {
        int n = this.numCoords;
        if (this.numTypes < 1) return null;
        if (n < 1) {
            return null;
        }
        if (this.pointTypes[this.numTypes - 1] != 4) return this.getPoint(n - 2);
        int n2 = this.numTypes - 2;
        while (n2 > 0) {
            switch (this.pointTypes[n2]) {
                case 0: {
                    return this.getPoint(n - 2);
                }
                case 1: {
                    n -= 2;
                    break;
                }
                case 2: {
                    n -= 4;
                    break;
                }
                case 3: {
                    n -= 6;
                }
            }
            --n2;
        }
        return this.getPoint(n - 2);
    }

    public final synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public abstract void transform(AffineTransform var1);

    public final synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        Path2D path2D = (Path2D)this.clone();
        if (affineTransform != null) {
            path2D.transform(affineTransform);
        }
        return path2D;
    }

    @Override
    public final Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public static boolean contains(PathIterator pathIterator, double d, double d2) {
        if (d * 0.0 + d2 * 0.0 == 0.0) {
            int n = pathIterator.getWindingRule() == 1 ? -1 : 1;
            int n2 = Curve.pointCrossingsForPath(pathIterator, d, d2);
            return (n2 & n) != 0;
        }
        return false;
    }

    public static boolean contains(PathIterator pathIterator, Point2D point2D) {
        return Path2D.contains(pathIterator, point2D.getX(), point2D.getY());
    }

    @Override
    public final boolean contains(double d, double d2) {
        if (d * 0.0 + d2 * 0.0 == 0.0) {
            if (this.numTypes < 2) {
                return false;
            }
            int n = this.windingRule == 1 ? -1 : 1;
            return (this.pointCrossings(d, d2) & n) != 0;
        }
        return false;
    }

    @Override
    public final boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public static boolean contains(PathIterator pathIterator, double d, double d2, double d3, double d4) {
        if (java.lang.Double.isNaN(d + d3) || java.lang.Double.isNaN(d2 + d4)) {
            return false;
        }
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        int n = pathIterator.getWindingRule() == 1 ? -1 : 2;
        int n2 = Curve.rectCrossingsForPath(pathIterator, d, d2, d + d3, d2 + d4);
        return n2 != Integer.MIN_VALUE && (n2 & n) != 0;
    }

    public static boolean contains(PathIterator pathIterator, Rectangle2D rectangle2D) {
        return Path2D.contains(pathIterator, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public final boolean contains(double d, double d2, double d3, double d4) {
        if (java.lang.Double.isNaN(d + d3) || java.lang.Double.isNaN(d2 + d4)) {
            return false;
        }
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        int n = this.windingRule == 1 ? -1 : 2;
        int n2 = this.rectCrossings(d, d2, d + d3, d2 + d4);
        return n2 != Integer.MIN_VALUE && (n2 & n) != 0;
    }

    @Override
    public final boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public static boolean intersects(PathIterator pathIterator, double d, double d2, double d3, double d4) {
        if (java.lang.Double.isNaN(d + d3) || java.lang.Double.isNaN(d2 + d4)) {
            return false;
        }
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        int n = pathIterator.getWindingRule() == 1 ? -1 : 2;
        int n2 = Curve.rectCrossingsForPath(pathIterator, d, d2, d + d3, d2 + d4);
        return n2 == Integer.MIN_VALUE || (n2 & n) != 0;
    }

    public static boolean intersects(PathIterator pathIterator, Rectangle2D rectangle2D) {
        return Path2D.intersects(pathIterator, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public final boolean intersects(double d, double d2, double d3, double d4) {
        if (java.lang.Double.isNaN(d + d3) || java.lang.Double.isNaN(d2 + d4)) {
            return false;
        }
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        int n = this.windingRule == 1 ? -1 : 2;
        int n2 = this.rectCrossings(d, d2, d + d3, d2 + d4);
        return n2 == Integer.MIN_VALUE || (n2 & n) != 0;
    }

    @Override
    public final boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public final PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public abstract Object clone();

    final void writeObject(ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        float[] fArray;
        double[] dArray;
        objectOutputStream.defaultWriteObject();
        if (bl) {
            dArray = ((Double)this).doubleCoords;
            fArray = null;
        } else {
            fArray = ((Float)this).floatCoords;
            dArray = null;
        }
        int n = this.numTypes;
        objectOutputStream.writeByte(bl ? 49 : 48);
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(this.numCoords);
        objectOutputStream.writeByte((byte)this.windingRule);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            switch (this.pointTypes[i]) {
                case 0: {
                    n4 = 1;
                    n3 = bl ? 80 : 64;
                    break;
                }
                case 1: {
                    n4 = 1;
                    n3 = bl ? 81 : 65;
                    break;
                }
                case 2: {
                    n4 = 2;
                    n3 = bl ? 82 : 66;
                    break;
                }
                case 3: {
                    n4 = 3;
                    n3 = bl ? 83 : 67;
                    break;
                }
                case 4: {
                    n4 = 0;
                    n3 = 96;
                    break;
                }
                default: {
                    throw new InternalError("unrecognized path type");
                }
            }
            objectOutputStream.writeByte(n3);
            while (--n4 >= 0) {
                if (bl) {
                    objectOutputStream.writeDouble(dArray[n2++]);
                    objectOutputStream.writeDouble(dArray[n2++]);
                    continue;
                }
                objectOutputStream.writeFloat(fArray[n2++]);
                objectOutputStream.writeFloat(fArray[n2++]);
            }
        }
        objectOutputStream.writeByte(97);
    }

    final void readObject(ObjectInputStream objectInputStream, boolean bl) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        objectInputStream.readByte();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        try {
            this.setWindingRule(objectInputStream.readByte());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(illegalArgumentException.getMessage());
        }
        this.pointTypes = new byte[n < 0 || n > 20 ? 20 : n];
        if (n2 < 0 || n2 > 40) {
            n2 = 40;
        }
        if (bl) {
            ((Double)this).doubleCoords = new double[n2];
        } else {
            ((Float)this).floatCoords = new float[n2];
        }
        block14: for (int i = 0; n < 0 || i < n; ++i) {
            int n3;
            int n4;
            boolean bl2;
            byte by = objectInputStream.readByte();
            switch (by) {
                case 64: {
                    bl2 = false;
                    n4 = 1;
                    n3 = 0;
                    break;
                }
                case 65: {
                    bl2 = false;
                    n4 = 1;
                    n3 = 1;
                    break;
                }
                case 66: {
                    bl2 = false;
                    n4 = 2;
                    n3 = 2;
                    break;
                }
                case 67: {
                    bl2 = false;
                    n4 = 3;
                    n3 = 3;
                    break;
                }
                case 80: {
                    bl2 = true;
                    n4 = 1;
                    n3 = 0;
                    break;
                }
                case 81: {
                    bl2 = true;
                    n4 = 1;
                    n3 = 1;
                    break;
                }
                case 82: {
                    bl2 = true;
                    n4 = 2;
                    n3 = 2;
                    break;
                }
                case 83: {
                    bl2 = true;
                    n4 = 3;
                    n3 = 3;
                    break;
                }
                case 96: {
                    bl2 = false;
                    n4 = 0;
                    n3 = 4;
                    break;
                }
                case 97: {
                    if (n < 0) break block14;
                    throw new StreamCorruptedException("unexpected PATH_END");
                }
                default: {
                    throw new StreamCorruptedException("unrecognized path type");
                }
            }
            this.needRoom(n3 != 0, n4 * 2);
            if (bl2) {
                while (--n4 >= 0) {
                    this.append(objectInputStream.readDouble(), objectInputStream.readDouble());
                }
            } else {
                while (--n4 >= 0) {
                    this.append(objectInputStream.readFloat(), objectInputStream.readFloat());
                }
            }
            this.pointTypes[this.numTypes++] = n3;
        }
        if (n >= 0 && objectInputStream.readByte() != 97) {
            throw new StreamCorruptedException("missing PATH_END");
        }
    }

    static abstract class Iterator
    implements PathIterator {
        int typeIdx;
        int pointIdx;
        Path2D path;
        static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};

        Iterator(Path2D path2D) {
            this.path = path2D;
        }

        @Override
        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        @Override
        public void next() {
            byte by = this.path.pointTypes[this.typeIdx++];
            this.pointIdx += curvecoords[by];
        }
    }

    public static class Double
    extends Path2D
    implements Serializable {
        transient double[] doubleCoords;
        private static final long serialVersionUID = 1826762518450014216L;

        public Double() {
            this(1, 20);
        }

        public Double(int n) {
            this(n, 20);
        }

        public Double(int n, int n2) {
            super(n, n2);
            this.doubleCoords = new double[n2 * 2];
        }

        public Double(Shape shape) {
            this(shape, null);
        }

        public Double(Shape shape, AffineTransform affineTransform) {
            if (shape instanceof Path2D) {
                Path2D path2D = (Path2D)shape;
                this.setWindingRule(path2D.windingRule);
                this.numTypes = path2D.numTypes;
                this.pointTypes = Arrays.copyOf(path2D.pointTypes, path2D.numTypes);
                this.numCoords = path2D.numCoords;
                this.doubleCoords = path2D.cloneCoordsDouble(affineTransform);
            } else {
                PathIterator pathIterator = shape.getPathIterator(affineTransform);
                this.setWindingRule(pathIterator.getWindingRule());
                this.pointTypes = new byte[20];
                this.doubleCoords = new double[40];
                this.append(pathIterator, false);
            }
        }

        @Override
        float[] cloneCoordsFloat(AffineTransform affineTransform) {
            float[] fArray = new float[this.numCoords];
            if (affineTransform == null) {
                for (int i = 0; i < this.numCoords; ++i) {
                    fArray[i] = (float)this.doubleCoords[i];
                }
            } else {
                affineTransform.transform(this.doubleCoords, 0, fArray, 0, this.numCoords / 2);
            }
            return fArray;
        }

        @Override
        double[] cloneCoordsDouble(AffineTransform affineTransform) {
            double[] dArray;
            if (affineTransform == null) {
                dArray = Arrays.copyOf(this.doubleCoords, this.numCoords);
            } else {
                dArray = new double[this.numCoords];
                affineTransform.transform(this.doubleCoords, 0, dArray, 0, this.numCoords / 2);
            }
            return dArray;
        }

        @Override
        void append(float f, float f2) {
            this.doubleCoords[this.numCoords++] = f;
            this.doubleCoords[this.numCoords++] = f2;
        }

        @Override
        void append(double d, double d2) {
            this.doubleCoords[this.numCoords++] = d;
            this.doubleCoords[this.numCoords++] = d2;
        }

        @Override
        Point2D getPoint(int n) {
            return new Point2D.Double(this.doubleCoords[n], this.doubleCoords[n + 1]);
        }

        @Override
        void needRoom(boolean bl, int n) {
            if (this.numTypes == 0 && bl) {
                throw new IllegalPathStateException("missing initial moveto in path definition");
            }
            if (this.numTypes >= this.pointTypes.length) {
                this.pointTypes = Double.expandPointTypes(this.pointTypes, 1);
            }
            if (this.numCoords > this.doubleCoords.length - n) {
                this.doubleCoords = Double.expandCoords(this.doubleCoords, n);
            }
        }

        static double[] expandCoords(double[] dArray, int n) {
            int n2 = dArray.length;
            int n3 = n2 + n;
            if (n3 < n2) {
                throw new ArrayIndexOutOfBoundsException("coords exceeds maximum capacity !");
            }
            int n4 = n2;
            if (n4 > 1000) {
                n4 = Math.max(1000, n2 >> 3);
            } else if (n4 < 10) {
                n4 = 10;
            }
            assert (n4 > n);
            int n5 = n2 + n4;
            if (n5 < n3) {
                n5 = Integer.MAX_VALUE;
            }
            while (true) {
                try {
                    return Arrays.copyOf(dArray, n5);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (n5 == n3) {
                        throw outOfMemoryError;
                    }
                    n5 = n3 + (n5 - n3) / 2;
                    continue;
                }
                break;
            }
        }

        @Override
        public final synchronized void moveTo(double d, double d2) {
            if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
                this.doubleCoords[this.numCoords - 2] = d;
                this.doubleCoords[this.numCoords - 1] = d2;
            } else {
                this.needRoom(false, 2);
                this.pointTypes[this.numTypes++] = 0;
                this.doubleCoords[this.numCoords++] = d;
                this.doubleCoords[this.numCoords++] = d2;
            }
        }

        @Override
        public final synchronized void lineTo(double d, double d2) {
            this.needRoom(true, 2);
            this.pointTypes[this.numTypes++] = 1;
            this.doubleCoords[this.numCoords++] = d;
            this.doubleCoords[this.numCoords++] = d2;
        }

        @Override
        public final synchronized void quadTo(double d, double d2, double d3, double d4) {
            this.needRoom(true, 4);
            this.pointTypes[this.numTypes++] = 2;
            this.doubleCoords[this.numCoords++] = d;
            this.doubleCoords[this.numCoords++] = d2;
            this.doubleCoords[this.numCoords++] = d3;
            this.doubleCoords[this.numCoords++] = d4;
        }

        @Override
        public final synchronized void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
            this.needRoom(true, 6);
            this.pointTypes[this.numTypes++] = 3;
            this.doubleCoords[this.numCoords++] = d;
            this.doubleCoords[this.numCoords++] = d2;
            this.doubleCoords[this.numCoords++] = d3;
            this.doubleCoords[this.numCoords++] = d4;
            this.doubleCoords[this.numCoords++] = d5;
            this.doubleCoords[this.numCoords++] = d6;
        }

        @Override
        int pointCrossings(double d, double d2) {
            double d3;
            double d4;
            if (this.numTypes == 0) {
                return 0;
            }
            double[] dArray = this.doubleCoords;
            double d5 = d4 = dArray[0];
            double d6 = d3 = dArray[1];
            int n = 0;
            int n2 = 2;
            block7: for (int i = 1; i < this.numTypes; ++i) {
                switch (this.pointTypes[i]) {
                    case 0: {
                        if (d6 != d3) {
                            n += Curve.pointCrossingsForLine(d, d2, d5, d6, d4, d3);
                        }
                        d4 = d5 = dArray[n2++];
                        d3 = d6 = dArray[n2++];
                        continue block7;
                    }
                    case 1: {
                        double d7 = dArray[n2++];
                        double d8 = dArray[n2++];
                        n += Curve.pointCrossingsForLine(d, d2, d5, d6, d7, d8);
                        d5 = d7;
                        d6 = d8;
                        continue block7;
                    }
                    case 2: {
                        int n3 = n2++;
                        int n4 = n2++;
                        double d7 = dArray[n2++];
                        double d8 = dArray[n2++];
                        n += Curve.pointCrossingsForQuad(d, d2, d5, d6, dArray[n3], dArray[n4], d7, d8, 0);
                        d5 = d7;
                        d6 = d8;
                        continue block7;
                    }
                    case 3: {
                        int n5 = n2++;
                        int n6 = n2++;
                        int n7 = n2++;
                        int n8 = n2++;
                        double d7 = dArray[n2++];
                        double d8 = dArray[n2++];
                        n += Curve.pointCrossingsForCubic(d, d2, d5, d6, dArray[n5], dArray[n6], dArray[n7], dArray[n8], d7, d8, 0);
                        d5 = d7;
                        d6 = d8;
                        continue block7;
                    }
                    case 4: {
                        if (d6 != d3) {
                            n += Curve.pointCrossingsForLine(d, d2, d5, d6, d4, d3);
                        }
                        d5 = d4;
                        d6 = d3;
                    }
                }
            }
            if (d6 != d3) {
                n += Curve.pointCrossingsForLine(d, d2, d5, d6, d4, d3);
            }
            return n;
        }

        @Override
        int rectCrossings(double d, double d2, double d3, double d4) {
            double d5;
            double d6;
            if (this.numTypes == 0) {
                return 0;
            }
            double[] dArray = this.doubleCoords;
            double d7 = d6 = dArray[0];
            double d8 = d5 = dArray[1];
            int n = 0;
            int n2 = 2;
            block7: for (int i = 1; n != Integer.MIN_VALUE && i < this.numTypes; ++i) {
                switch (this.pointTypes[i]) {
                    case 0: {
                        if (d7 != d6 || d8 != d5) {
                            n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d6, d5);
                        }
                        d6 = d7 = dArray[n2++];
                        d5 = d8 = dArray[n2++];
                        continue block7;
                    }
                    case 1: {
                        double d9 = dArray[n2++];
                        double d10 = dArray[n2++];
                        n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d9, d10);
                        d7 = d9;
                        d8 = d10;
                        continue block7;
                    }
                    case 2: {
                        int n3 = n2++;
                        int n4 = n2++;
                        double d9 = dArray[n2++];
                        double d10 = dArray[n2++];
                        n = Curve.rectCrossingsForQuad(n, d, d2, d3, d4, d7, d8, dArray[n3], dArray[n4], d9, d10, 0);
                        d7 = d9;
                        d8 = d10;
                        continue block7;
                    }
                    case 3: {
                        int n5 = n2++;
                        int n6 = n2++;
                        int n7 = n2++;
                        int n8 = n2++;
                        double d9 = dArray[n2++];
                        double d10 = dArray[n2++];
                        n = Curve.rectCrossingsForCubic(n, d, d2, d3, d4, d7, d8, dArray[n5], dArray[n6], dArray[n7], dArray[n8], d9, d10, 0);
                        d7 = d9;
                        d8 = d10;
                        continue block7;
                    }
                    case 4: {
                        if (d7 != d6 || d8 != d5) {
                            n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d6, d5);
                        }
                        d7 = d6;
                        d8 = d5;
                    }
                }
            }
            if (n != Integer.MIN_VALUE && (d7 != d6 || d8 != d5)) {
                n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d6, d5);
            }
            return n;
        }

        @Override
        public final void append(PathIterator pathIterator, boolean bl) {
            double[] dArray = new double[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(dArray)) {
                    case 0: {
                        if (!bl || this.numTypes < 1 || this.numCoords < 1) {
                            this.moveTo(dArray[0], dArray[1]);
                            break;
                        }
                        if (this.pointTypes[this.numTypes - 1] != 4 && this.doubleCoords[this.numCoords - 2] == dArray[0] && this.doubleCoords[this.numCoords - 1] == dArray[1]) break;
                        this.lineTo(dArray[0], dArray[1]);
                        break;
                    }
                    case 1: {
                        this.lineTo(dArray[0], dArray[1]);
                        break;
                    }
                    case 2: {
                        this.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 3: {
                        this.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        break;
                    }
                    case 4: {
                        this.closePath();
                    }
                }
                pathIterator.next();
                bl = false;
            }
        }

        @Override
        public final void transform(AffineTransform affineTransform) {
            affineTransform.transform(this.doubleCoords, 0, this.doubleCoords, 0, this.numCoords / 2);
        }

        @Override
        public final synchronized Rectangle2D getBounds2D() {
            double d;
            double d2;
            double d3;
            double d4;
            int n = this.numCoords;
            if (n > 0) {
                d3 = d4 = this.doubleCoords[--n];
                d = d2 = this.doubleCoords[--n];
                while (n > 0) {
                    double d5;
                    double d6 = this.doubleCoords[--n];
                    if ((d5 = this.doubleCoords[--n]) < d) {
                        d = d5;
                    }
                    if (d6 < d3) {
                        d3 = d6;
                    }
                    if (d5 > d2) {
                        d2 = d5;
                    }
                    if (!(d6 > d4)) continue;
                    d4 = d6;
                }
            } else {
                d4 = 0.0;
                d2 = 0.0;
                d3 = 0.0;
                d = 0.0;
            }
            return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        }

        @Override
        public final PathIterator getPathIterator(AffineTransform affineTransform) {
            if (affineTransform == null) {
                return new CopyIterator(this);
            }
            return new TxIterator(this, affineTransform);
        }

        @Override
        public final Object clone() {
            return new Double(this);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            super.writeObject(objectOutputStream, true);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            super.readObject(objectInputStream, true);
        }

        static class TxIterator
        extends Iterator {
            double[] doubleCoords;
            AffineTransform affine;

            TxIterator(Double double_, AffineTransform affineTransform) {
                super(double_);
                this.doubleCoords = double_.doubleCoords;
                this.affine = affineTransform;
            }

            @Override
            public int currentSegment(float[] fArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    this.affine.transform(this.doubleCoords, this.pointIdx, fArray, 0, n / 2);
                }
                return by;
            }

            @Override
            public int currentSegment(double[] dArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    this.affine.transform(this.doubleCoords, this.pointIdx, dArray, 0, n / 2);
                }
                return by;
            }
        }

        static class CopyIterator
        extends Iterator {
            double[] doubleCoords;

            CopyIterator(Double double_) {
                super(double_);
                this.doubleCoords = double_.doubleCoords;
            }

            @Override
            public int currentSegment(float[] fArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        fArray[i] = (float)this.doubleCoords[this.pointIdx + i];
                    }
                }
                return by;
            }

            @Override
            public int currentSegment(double[] dArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    System.arraycopy((Object)this.doubleCoords, this.pointIdx, (Object)dArray, 0, n);
                }
                return by;
            }
        }
    }

    public static class Float
    extends Path2D
    implements Serializable {
        transient float[] floatCoords;
        private static final long serialVersionUID = 6990832515060788886L;

        public Float() {
            this(1, 20);
        }

        public Float(int n) {
            this(n, 20);
        }

        public Float(int n, int n2) {
            super(n, n2);
            this.floatCoords = new float[n2 * 2];
        }

        public Float(Shape shape) {
            this(shape, null);
        }

        public Float(Shape shape, AffineTransform affineTransform) {
            if (shape instanceof Path2D) {
                Path2D path2D = (Path2D)shape;
                this.setWindingRule(path2D.windingRule);
                this.numTypes = path2D.numTypes;
                this.pointTypes = Arrays.copyOf(path2D.pointTypes, path2D.numTypes);
                this.numCoords = path2D.numCoords;
                this.floatCoords = path2D.cloneCoordsFloat(affineTransform);
            } else {
                PathIterator pathIterator = shape.getPathIterator(affineTransform);
                this.setWindingRule(pathIterator.getWindingRule());
                this.pointTypes = new byte[20];
                this.floatCoords = new float[40];
                this.append(pathIterator, false);
            }
        }

        @Override
        float[] cloneCoordsFloat(AffineTransform affineTransform) {
            float[] fArray;
            if (affineTransform == null) {
                fArray = Arrays.copyOf(this.floatCoords, this.numCoords);
            } else {
                fArray = new float[this.numCoords];
                affineTransform.transform(this.floatCoords, 0, fArray, 0, this.numCoords / 2);
            }
            return fArray;
        }

        @Override
        double[] cloneCoordsDouble(AffineTransform affineTransform) {
            double[] dArray = new double[this.numCoords];
            if (affineTransform == null) {
                for (int i = 0; i < this.numCoords; ++i) {
                    dArray[i] = this.floatCoords[i];
                }
            } else {
                affineTransform.transform(this.floatCoords, 0, dArray, 0, this.numCoords / 2);
            }
            return dArray;
        }

        @Override
        void append(float f, float f2) {
            this.floatCoords[this.numCoords++] = f;
            this.floatCoords[this.numCoords++] = f2;
        }

        @Override
        void append(double d, double d2) {
            this.floatCoords[this.numCoords++] = (float)d;
            this.floatCoords[this.numCoords++] = (float)d2;
        }

        @Override
        Point2D getPoint(int n) {
            return new Point2D.Float(this.floatCoords[n], this.floatCoords[n + 1]);
        }

        @Override
        void needRoom(boolean bl, int n) {
            if (this.numTypes == 0 && bl) {
                throw new IllegalPathStateException("missing initial moveto in path definition");
            }
            if (this.numTypes >= this.pointTypes.length) {
                this.pointTypes = Float.expandPointTypes(this.pointTypes, 1);
            }
            if (this.numCoords > this.floatCoords.length - n) {
                this.floatCoords = Float.expandCoords(this.floatCoords, n);
            }
        }

        static float[] expandCoords(float[] fArray, int n) {
            int n2 = fArray.length;
            int n3 = n2 + n;
            if (n3 < n2) {
                throw new ArrayIndexOutOfBoundsException("coords exceeds maximum capacity !");
            }
            int n4 = n2;
            if (n4 > 1000) {
                n4 = Math.max(1000, n2 >> 3);
            } else if (n4 < 10) {
                n4 = 10;
            }
            assert (n4 > n);
            int n5 = n2 + n4;
            if (n5 < n3) {
                n5 = Integer.MAX_VALUE;
            }
            while (true) {
                try {
                    return Arrays.copyOf(fArray, n5);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (n5 == n3) {
                        throw outOfMemoryError;
                    }
                    n5 = n3 + (n5 - n3) / 2;
                    continue;
                }
                break;
            }
        }

        @Override
        public final synchronized void moveTo(double d, double d2) {
            if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
                this.floatCoords[this.numCoords - 2] = (float)d;
                this.floatCoords[this.numCoords - 1] = (float)d2;
            } else {
                this.needRoom(false, 2);
                this.pointTypes[this.numTypes++] = 0;
                this.floatCoords[this.numCoords++] = (float)d;
                this.floatCoords[this.numCoords++] = (float)d2;
            }
        }

        public final synchronized void moveTo(float f, float f2) {
            if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
                this.floatCoords[this.numCoords - 2] = f;
                this.floatCoords[this.numCoords - 1] = f2;
            } else {
                this.needRoom(false, 2);
                this.pointTypes[this.numTypes++] = 0;
                this.floatCoords[this.numCoords++] = f;
                this.floatCoords[this.numCoords++] = f2;
            }
        }

        @Override
        public final synchronized void lineTo(double d, double d2) {
            this.needRoom(true, 2);
            this.pointTypes[this.numTypes++] = 1;
            this.floatCoords[this.numCoords++] = (float)d;
            this.floatCoords[this.numCoords++] = (float)d2;
        }

        public final synchronized void lineTo(float f, float f2) {
            this.needRoom(true, 2);
            this.pointTypes[this.numTypes++] = 1;
            this.floatCoords[this.numCoords++] = f;
            this.floatCoords[this.numCoords++] = f2;
        }

        @Override
        public final synchronized void quadTo(double d, double d2, double d3, double d4) {
            this.needRoom(true, 4);
            this.pointTypes[this.numTypes++] = 2;
            this.floatCoords[this.numCoords++] = (float)d;
            this.floatCoords[this.numCoords++] = (float)d2;
            this.floatCoords[this.numCoords++] = (float)d3;
            this.floatCoords[this.numCoords++] = (float)d4;
        }

        public final synchronized void quadTo(float f, float f2, float f3, float f4) {
            this.needRoom(true, 4);
            this.pointTypes[this.numTypes++] = 2;
            this.floatCoords[this.numCoords++] = f;
            this.floatCoords[this.numCoords++] = f2;
            this.floatCoords[this.numCoords++] = f3;
            this.floatCoords[this.numCoords++] = f4;
        }

        @Override
        public final synchronized void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
            this.needRoom(true, 6);
            this.pointTypes[this.numTypes++] = 3;
            this.floatCoords[this.numCoords++] = (float)d;
            this.floatCoords[this.numCoords++] = (float)d2;
            this.floatCoords[this.numCoords++] = (float)d3;
            this.floatCoords[this.numCoords++] = (float)d4;
            this.floatCoords[this.numCoords++] = (float)d5;
            this.floatCoords[this.numCoords++] = (float)d6;
        }

        public final synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.needRoom(true, 6);
            this.pointTypes[this.numTypes++] = 3;
            this.floatCoords[this.numCoords++] = f;
            this.floatCoords[this.numCoords++] = f2;
            this.floatCoords[this.numCoords++] = f3;
            this.floatCoords[this.numCoords++] = f4;
            this.floatCoords[this.numCoords++] = f5;
            this.floatCoords[this.numCoords++] = f6;
        }

        @Override
        int pointCrossings(double d, double d2) {
            double d3;
            double d4;
            if (this.numTypes == 0) {
                return 0;
            }
            float[] fArray = this.floatCoords;
            double d5 = d4 = (double)fArray[0];
            double d6 = d3 = (double)fArray[1];
            int n = 0;
            int n2 = 2;
            block7: for (int i = 1; i < this.numTypes; ++i) {
                switch (this.pointTypes[i]) {
                    case 0: {
                        if (d6 != d3) {
                            n += Curve.pointCrossingsForLine(d, d2, d5, d6, d4, d3);
                        }
                        d4 = d5 = (double)fArray[n2++];
                        d3 = d6 = (double)fArray[n2++];
                        continue block7;
                    }
                    case 1: {
                        double d7 = fArray[n2++];
                        double d8 = fArray[n2++];
                        n += Curve.pointCrossingsForLine(d, d2, d5, d6, d7, d8);
                        d5 = d7;
                        d6 = d8;
                        continue block7;
                    }
                    case 2: {
                        int n3 = n2++;
                        int n4 = n2++;
                        double d7 = fArray[n2++];
                        double d8 = fArray[n2++];
                        n += Curve.pointCrossingsForQuad(d, d2, d5, d6, fArray[n3], fArray[n4], d7, d8, 0);
                        d5 = d7;
                        d6 = d8;
                        continue block7;
                    }
                    case 3: {
                        int n5 = n2++;
                        int n6 = n2++;
                        int n7 = n2++;
                        int n8 = n2++;
                        double d7 = fArray[n2++];
                        double d8 = fArray[n2++];
                        n += Curve.pointCrossingsForCubic(d, d2, d5, d6, fArray[n5], fArray[n6], fArray[n7], fArray[n8], d7, d8, 0);
                        d5 = d7;
                        d6 = d8;
                        continue block7;
                    }
                    case 4: {
                        if (d6 != d3) {
                            n += Curve.pointCrossingsForLine(d, d2, d5, d6, d4, d3);
                        }
                        d5 = d4;
                        d6 = d3;
                    }
                }
            }
            if (d6 != d3) {
                n += Curve.pointCrossingsForLine(d, d2, d5, d6, d4, d3);
            }
            return n;
        }

        @Override
        int rectCrossings(double d, double d2, double d3, double d4) {
            double d5;
            double d6;
            if (this.numTypes == 0) {
                return 0;
            }
            float[] fArray = this.floatCoords;
            double d7 = d6 = (double)fArray[0];
            double d8 = d5 = (double)fArray[1];
            int n = 0;
            int n2 = 2;
            block7: for (int i = 1; n != Integer.MIN_VALUE && i < this.numTypes; ++i) {
                switch (this.pointTypes[i]) {
                    case 0: {
                        if (d7 != d6 || d8 != d5) {
                            n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d6, d5);
                        }
                        d6 = d7 = (double)fArray[n2++];
                        d5 = d8 = (double)fArray[n2++];
                        continue block7;
                    }
                    case 1: {
                        double d9 = fArray[n2++];
                        double d10 = fArray[n2++];
                        n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d9, d10);
                        d7 = d9;
                        d8 = d10;
                        continue block7;
                    }
                    case 2: {
                        int n3 = n2++;
                        int n4 = n2++;
                        double d9 = fArray[n2++];
                        double d10 = fArray[n2++];
                        n = Curve.rectCrossingsForQuad(n, d, d2, d3, d4, d7, d8, fArray[n3], fArray[n4], d9, d10, 0);
                        d7 = d9;
                        d8 = d10;
                        continue block7;
                    }
                    case 3: {
                        int n5 = n2++;
                        int n6 = n2++;
                        int n7 = n2++;
                        int n8 = n2++;
                        double d9 = fArray[n2++];
                        double d10 = fArray[n2++];
                        n = Curve.rectCrossingsForCubic(n, d, d2, d3, d4, d7, d8, fArray[n5], fArray[n6], fArray[n7], fArray[n8], d9, d10, 0);
                        d7 = d9;
                        d8 = d10;
                        continue block7;
                    }
                    case 4: {
                        if (d7 != d6 || d8 != d5) {
                            n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d6, d5);
                        }
                        d7 = d6;
                        d8 = d5;
                    }
                }
            }
            if (n != Integer.MIN_VALUE && (d7 != d6 || d8 != d5)) {
                n = Curve.rectCrossingsForLine(n, d, d2, d3, d4, d7, d8, d6, d5);
            }
            return n;
        }

        @Override
        public final void append(PathIterator pathIterator, boolean bl) {
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        if (!bl || this.numTypes < 1 || this.numCoords < 1) {
                            this.moveTo(fArray[0], fArray[1]);
                            break;
                        }
                        if (this.pointTypes[this.numTypes - 1] != 4 && this.floatCoords[this.numCoords - 2] == fArray[0] && this.floatCoords[this.numCoords - 1] == fArray[1]) break;
                        this.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        this.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        this.closePath();
                    }
                }
                pathIterator.next();
                bl = false;
            }
        }

        @Override
        public final void transform(AffineTransform affineTransform) {
            affineTransform.transform(this.floatCoords, 0, this.floatCoords, 0, this.numCoords / 2);
        }

        @Override
        public final synchronized Rectangle2D getBounds2D() {
            float f;
            float f2;
            float f3;
            float f4;
            int n = this.numCoords;
            if (n > 0) {
                f3 = f4 = this.floatCoords[--n];
                f = f2 = this.floatCoords[--n];
                while (n > 0) {
                    float f5;
                    float f6 = this.floatCoords[--n];
                    if ((f5 = this.floatCoords[--n]) < f) {
                        f = f5;
                    }
                    if (f6 < f3) {
                        f3 = f6;
                    }
                    if (f5 > f2) {
                        f2 = f5;
                    }
                    if (!(f6 > f4)) continue;
                    f4 = f6;
                }
            } else {
                f4 = 0.0f;
                f2 = 0.0f;
                f3 = 0.0f;
                f = 0.0f;
            }
            return new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        }

        @Override
        public final PathIterator getPathIterator(AffineTransform affineTransform) {
            if (affineTransform == null) {
                return new CopyIterator(this);
            }
            return new TxIterator(this, affineTransform);
        }

        @Override
        public final Object clone() {
            if (this instanceof GeneralPath) {
                return new GeneralPath(this);
            }
            return new Float(this);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            super.writeObject(objectOutputStream, false);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            super.readObject(objectInputStream, false);
        }

        static class TxIterator
        extends Iterator {
            float[] floatCoords;
            AffineTransform affine;

            TxIterator(Float float_, AffineTransform affineTransform) {
                super(float_);
                this.floatCoords = float_.floatCoords;
                this.affine = affineTransform;
            }

            @Override
            public int currentSegment(float[] fArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    this.affine.transform(this.floatCoords, this.pointIdx, fArray, 0, n / 2);
                }
                return by;
            }

            @Override
            public int currentSegment(double[] dArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    this.affine.transform(this.floatCoords, this.pointIdx, dArray, 0, n / 2);
                }
                return by;
            }
        }

        static class CopyIterator
        extends Iterator {
            float[] floatCoords;

            CopyIterator(Float float_) {
                super(float_);
                this.floatCoords = float_.floatCoords;
            }

            @Override
            public int currentSegment(float[] fArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    System.arraycopy((Object)this.floatCoords, this.pointIdx, (Object)fArray, 0, n);
                }
                return by;
            }

            @Override
            public int currentSegment(double[] dArray) {
                byte by = this.path.pointTypes[this.typeIdx];
                int n = curvecoords[by];
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        dArray[i] = this.floatCoords[this.pointIdx + i];
                    }
                }
                return by;
            }
        }
    }
}

