/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.ntlm;

import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.HexDumpEncoder;
import sun.security.provider.MD4;

class NTLM {
    private final SecretKeyFactory fac;
    private final Cipher cipher;
    private final MessageDigest md4;
    private final Mac hmac;
    private final MessageDigest md5;
    private static final boolean DEBUG = System.getProperty("ntlm.debug") != null;
    final Version v;
    final boolean writeLM;
    final boolean writeNTLM;

    protected NTLM(String string) throws NTLMException {
        if (string == null) {
            string = "LMv2/NTLMv2";
        }
        switch (string) {
            case "LM": {
                this.v = Version.NTLM;
                this.writeLM = true;
                this.writeNTLM = false;
                break;
            }
            case "NTLM": {
                this.v = Version.NTLM;
                this.writeLM = false;
                this.writeNTLM = true;
                break;
            }
            case "LM/NTLM": {
                this.v = Version.NTLM;
                this.writeNTLM = true;
                this.writeLM = true;
                break;
            }
            case "NTLM2": {
                this.v = Version.NTLM2;
                this.writeNTLM = true;
                this.writeLM = true;
                break;
            }
            case "LMv2": {
                this.v = Version.NTLMv2;
                this.writeLM = true;
                this.writeNTLM = false;
                break;
            }
            case "NTLMv2": {
                this.v = Version.NTLMv2;
                this.writeLM = false;
                this.writeNTLM = true;
                break;
            }
            case "LMv2/NTLMv2": {
                this.v = Version.NTLMv2;
                this.writeNTLM = true;
                this.writeLM = true;
                break;
            }
            default: {
                throw new NTLMException(5, "Unknown version " + string);
            }
        }
        try {
            this.fac = SecretKeyFactory.getInstance("DES");
            this.cipher = Cipher.getInstance("DES/ECB/NoPadding");
            this.md4 = MD4.getInstance();
            this.hmac = Mac.getInstance("HmacMD5");
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new AssertionError();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (DEBUG) {
            System.out.printf(string, objectArray);
        }
    }

    public void debug(byte[] byArray) {
        if (DEBUG) {
            try {
                new HexDumpEncoder().encodeBuffer(byArray, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    byte[] makeDesKey(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[i] < 0 ? byArray[i] + 256 : byArray[i];
        }
        byte[] byArray2 = new byte[]{(byte)nArray[n + 0], (byte)(nArray[n + 0] << 7 & 0xFF | nArray[n + 1] >> 1), (byte)(nArray[n + 1] << 6 & 0xFF | nArray[n + 2] >> 2), (byte)(nArray[n + 2] << 5 & 0xFF | nArray[n + 3] >> 3), (byte)(nArray[n + 3] << 4 & 0xFF | nArray[n + 4] >> 4), (byte)(nArray[n + 4] << 3 & 0xFF | nArray[n + 5] >> 5), (byte)(nArray[n + 5] << 2 & 0xFF | nArray[n + 6] >> 6), (byte)(nArray[n + 6] << 1 & 0xFF)};
        return byArray2;
    }

    byte[] calcLMHash(byte[] byArray) {
        block9: {
            byte[] byArray2 = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
            byte[] byArray3 = new byte[14];
            int n = byArray.length;
            if (n > 14) {
                n = 14;
            }
            System.arraycopy((Object)byArray, 0, (Object)byArray3, 0, n);
            try {
                DESKeySpec dESKeySpec = new DESKeySpec(this.makeDesKey(byArray3, 0));
                DESKeySpec dESKeySpec2 = new DESKeySpec(this.makeDesKey(byArray3, 7));
                SecretKey secretKey = this.fac.generateSecret(dESKeySpec);
                SecretKey secretKey2 = this.fac.generateSecret(dESKeySpec2);
                this.cipher.init(1, secretKey);
                byte[] byArray4 = this.cipher.doFinal(byArray2, 0, 8);
                this.cipher.init(1, secretKey2);
                byte[] byArray5 = this.cipher.doFinal(byArray2, 0, 8);
                byte[] byArray6 = new byte[21];
                System.arraycopy((Object)byArray4, 0, (Object)byArray6, 0, 8);
                System.arraycopy((Object)byArray5, 0, (Object)byArray6, 8, 8);
                return byArray6;
            }
            catch (InvalidKeyException invalidKeyException) {
                assert (false);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                assert (false);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                assert (false);
            }
            catch (BadPaddingException badPaddingException) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        return null;
    }

    byte[] calcNTHash(byte[] byArray) {
        byte[] byArray2 = this.md4.digest(byArray);
        byte[] byArray3 = new byte[21];
        System.arraycopy((Object)byArray2, 0, (Object)byArray3, 0, 16);
        return byArray3;
    }

    byte[] calcResponse(byte[] byArray, byte[] byArray2) {
        block9: {
            try {
                assert (byArray.length == 21);
                DESKeySpec dESKeySpec = new DESKeySpec(this.makeDesKey(byArray, 0));
                DESKeySpec dESKeySpec2 = new DESKeySpec(this.makeDesKey(byArray, 7));
                DESKeySpec dESKeySpec3 = new DESKeySpec(this.makeDesKey(byArray, 14));
                SecretKey secretKey = this.fac.generateSecret(dESKeySpec);
                SecretKey secretKey2 = this.fac.generateSecret(dESKeySpec2);
                SecretKey secretKey3 = this.fac.generateSecret(dESKeySpec3);
                this.cipher.init(1, secretKey);
                byte[] byArray3 = this.cipher.doFinal(byArray2, 0, 8);
                this.cipher.init(1, secretKey2);
                byte[] byArray4 = this.cipher.doFinal(byArray2, 0, 8);
                this.cipher.init(1, secretKey3);
                byte[] byArray5 = this.cipher.doFinal(byArray2, 0, 8);
                byte[] byArray6 = new byte[24];
                System.arraycopy((Object)byArray3, 0, (Object)byArray6, 0, 8);
                System.arraycopy((Object)byArray4, 0, (Object)byArray6, 8, 8);
                System.arraycopy((Object)byArray5, 0, (Object)byArray6, 16, 8);
                return byArray6;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                assert (false);
            }
            catch (BadPaddingException badPaddingException) {
                assert (false);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                assert (false);
            }
            catch (InvalidKeyException invalidKeyException) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        return null;
    }

    byte[] hmacMD5(byte[] byArray, byte[] byArray2) {
        block4: {
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(Arrays.copyOf(byArray, 16), "HmacMD5");
                this.hmac.init(secretKeySpec);
                return this.hmac.doFinal(byArray2);
            }
            catch (InvalidKeyException invalidKeyException) {
                assert (false);
            }
            catch (RuntimeException runtimeException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return null;
    }

    byte[] calcV2(byte[] byArray, String string, byte[] byArray2, byte[] byArray3) {
        try {
            byte[] byArray4 = this.hmacMD5(byArray, string.getBytes("UnicodeLittleUnmarked"));
            byte[] byArray5 = new byte[byArray2.length + 8];
            System.arraycopy((Object)byArray3, 0, (Object)byArray5, 0, 8);
            System.arraycopy((Object)byArray2, 0, (Object)byArray5, 8, byArray2.length);
            byte[] byArray6 = new byte[16 + byArray2.length];
            System.arraycopy((Object)this.hmacMD5(byArray4, byArray5), 0, (Object)byArray6, 0, 16);
            System.arraycopy((Object)byArray2, 0, (Object)byArray6, 16, byArray2.length);
            return byArray6;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    static byte[] ntlm2LM(byte[] byArray) {
        return Arrays.copyOf(byArray, 24);
    }

    byte[] ntlm2NTLM(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = Arrays.copyOf(byArray3, 16);
        System.arraycopy((Object)byArray2, 0, (Object)byArray4, 8, 8);
        byte[] byArray5 = Arrays.copyOf(this.md5.digest(byArray4), 8);
        return this.calcResponse(byArray, byArray5);
    }

    static byte[] getP1(char[] cArray) {
        try {
            return new String(cArray).toUpperCase(Locale.ENGLISH).getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static byte[] getP2(char[] cArray) {
        try {
            return new String(cArray).getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static class Writer {
        private byte[] internal;
        private int current;

        Writer(int n, int n2) {
            assert (n2 < 256);
            this.internal = new byte[256];
            this.current = n2;
            System.arraycopy((Object)new byte[]{78, 84, 76, 77, 83, 83, 80, 0, (byte)n}, 0, (Object)this.internal, 0, 9);
        }

        void writeShort(int n, int n2) {
            this.internal[n] = (byte)n2;
            this.internal[n + 1] = (byte)(n2 >> 8);
        }

        void writeInt(int n, int n2) {
            this.internal[n] = (byte)n2;
            this.internal[n + 1] = (byte)(n2 >> 8);
            this.internal[n + 2] = (byte)(n2 >> 16);
            this.internal[n + 3] = (byte)(n2 >> 24);
        }

        void writeBytes(int n, byte[] byArray) {
            System.arraycopy((Object)byArray, 0, (Object)this.internal, n, byArray.length);
        }

        void writeSecurityBuffer(int n, byte[] byArray) {
            if (byArray == null) {
                this.writeShort(n + 4, this.current);
            } else {
                int n2 = byArray.length;
                if (this.current + n2 > this.internal.length) {
                    this.internal = Arrays.copyOf(this.internal, this.current + n2 + 256);
                }
                this.writeShort(n, n2);
                this.writeShort(n + 2, n2);
                this.writeShort(n + 4, this.current);
                System.arraycopy((Object)byArray, 0, (Object)this.internal, this.current, n2);
                this.current += n2;
            }
        }

        void writeSecurityBuffer(int n, String string, boolean bl) {
            block2: {
                try {
                    this.writeSecurityBuffer(n, string == null ? null : string.getBytes(bl ? "UnicodeLittleUnmarked" : "ISO8859_1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        byte[] getBytes() {
            return Arrays.copyOf(this.internal, this.current);
        }
    }

    static class Reader {
        private final byte[] internal;

        Reader(byte[] byArray) {
            this.internal = byArray;
        }

        int readInt(int n) throws NTLMException {
            try {
                return (this.internal[n] & 0xFF) + ((this.internal[n + 1] & 0xFF) << 8) + ((this.internal[n + 2] & 0xFF) << 16) + ((this.internal[n + 3] & 0xFF) << 24);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        int readShort(int n) throws NTLMException {
            try {
                return (this.internal[n] & 0xFF) + ((this.internal[n + 1] & 0xFF) << 8);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        byte[] readBytes(int n, int n2) throws NTLMException {
            try {
                return Arrays.copyOfRange(this.internal, n, n + n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        byte[] readSecurityBuffer(int n) throws NTLMException {
            int n2 = this.readInt(n + 4);
            if (n2 == 0) {
                return new byte[0];
            }
            try {
                return Arrays.copyOfRange(this.internal, n2, n2 + this.readShort(n));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        String readSecurityBuffer(int n, boolean bl) throws NTLMException {
            byte[] byArray = this.readSecurityBuffer(n);
            try {
                return byArray == null ? null : new String(byArray, bl ? "UnicodeLittleUnmarked" : "ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NTLMException(1, "Invalid input encoding");
            }
        }
    }
}

