/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.FastShortMessage;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

final class SMFParser {
    private static final int MTrk_MAGIC = 1297379947;
    private static final boolean STRICT_PARSER = false;
    private static final boolean DEBUG = false;
    int tracks;
    DataInputStream stream;
    private int trackLength = 0;
    private byte[] trackData = null;
    private int pos = 0;

    SMFParser() {
    }

    private int readUnsigned() throws IOException {
        return this.trackData[this.pos++] & 0xFF;
    }

    private void read(byte[] byArray) throws IOException {
        System.arraycopy((Object)this.trackData, this.pos, (Object)byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    private long readVarInt() throws IOException {
        long l = 0L;
        int n = 0;
        do {
            n = this.trackData[this.pos++] & 0xFF;
            l = (l << 7) + (long)(n & 0x7F);
        } while ((n & 0x80) != 0);
        return l;
    }

    private int readIntFromStream() throws IOException {
        try {
            return this.stream.readInt();
        }
        catch (EOFException eOFException) {
            throw new EOFException("invalid MIDI file");
        }
    }

    boolean nextTrack() throws IOException, InvalidMidiDataException {
        int n;
        this.trackLength = 0;
        do {
            if (this.stream.skipBytes(this.trackLength) != this.trackLength) {
                return false;
            }
            n = this.readIntFromStream();
            this.trackLength = this.readIntFromStream();
        } while (n != 1297379947);
        if (this.trackLength < 0) {
            return false;
        }
        try {
            this.trackData = new byte[this.trackLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Track length too big", outOfMemoryError);
        }
        try {
            this.stream.readFully(this.trackData);
        }
        catch (EOFException eOFException) {
            return false;
        }
        this.pos = 0;
        return true;
    }

    private boolean trackFinished() {
        return this.pos >= this.trackLength;
    }

    void readTrack(Track track) throws IOException, InvalidMidiDataException {
        try {
            long l = 0L;
            int n = 0;
            boolean bl = false;
            while (!this.trackFinished() && !bl) {
                MidiMessage midiMessage;
                int n2 = -1;
                int n3 = 0;
                l += this.readVarInt();
                int n4 = this.readUnsigned();
                if (n4 >= 128) {
                    n = n4;
                } else {
                    n2 = n4;
                }
                block2 : switch (n & 0xF0) {
                    case 128: 
                    case 144: 
                    case 160: 
                    case 176: 
                    case 224: {
                        if (n2 == -1) {
                            n2 = this.readUnsigned();
                        }
                        n3 = this.readUnsigned();
                        midiMessage = new FastShortMessage(n | n2 << 8 | n3 << 16);
                        break;
                    }
                    case 192: 
                    case 208: {
                        if (n2 == -1) {
                            n2 = this.readUnsigned();
                        }
                        midiMessage = new FastShortMessage(n | n2 << 8);
                        break;
                    }
                    case 240: {
                        switch (n) {
                            case 240: 
                            case 247: {
                                int n5 = (int)this.readVarInt();
                                byte[] byArray = new byte[n5];
                                this.read(byArray);
                                SysexMessage sysexMessage = new SysexMessage();
                                sysexMessage.setMessage(n, byArray, n5);
                                midiMessage = sysexMessage;
                                break block2;
                            }
                            case 255: {
                                byte[] byArray;
                                int n6 = this.readUnsigned();
                                int n7 = (int)this.readVarInt();
                                if (n7 < 0) {
                                    throw new InvalidMidiDataException("length out of bounds: " + n7);
                                }
                                try {
                                    byArray = new byte[n7];
                                }
                                catch (OutOfMemoryError outOfMemoryError) {
                                    throw new IOException("Meta length too big", outOfMemoryError);
                                }
                                this.read(byArray);
                                MetaMessage metaMessage = new MetaMessage();
                                metaMessage.setMessage(n6, byArray, n7);
                                midiMessage = metaMessage;
                                if (n6 != 47) break block2;
                                bl = true;
                                break block2;
                            }
                            default: {
                                throw new InvalidMidiDataException("Invalid status byte: " + n);
                            }
                        }
                    }
                    default: {
                        throw new InvalidMidiDataException("Invalid status byte: " + n);
                    }
                }
                track.add(new MidiEvent(midiMessage, l));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException("invalid MIDI file");
        }
    }
}

