/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

final class Fixups
extends AbstractCollection<Fixup> {
    byte[] bytes;
    int head;
    int tail;
    int size;
    ConstantPool.Entry[] entries;
    int[] bigDescs;
    private static final int MINBIGSIZE = 1;
    private static final int[] noBigDescs = new int[]{1};
    private static final int LOC_SHIFT = 1;
    private static final int FMT_MASK = 1;
    private static final byte UNUSED_BYTE = 0;
    private static final byte OVERFLOW_BYTE = -1;
    private static final int BIGSIZE = 0;
    private static final int U2_FORMAT = 0;
    private static final int U1_FORMAT = 1;
    private static final int SPECIAL_LOC = 0;
    private static final int SPECIAL_FMT = 0;

    Fixups(byte[] byArray) {
        this.bytes = byArray;
        this.entries = new ConstantPool.Entry[3];
        this.bigDescs = noBigDescs;
    }

    Fixups() {
        this((byte[])null);
    }

    Fixups(byte[] byArray, Collection<Fixup> collection) {
        this(byArray);
        this.addAll((Collection<? extends Fixup>)collection);
    }

    Fixups(Collection<Fixup> collection) {
        this((byte[])null);
        this.addAll((Collection<? extends Fixup>)collection);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        int n;
        if (this.size != this.entries.length) {
            ConstantPool.Entry[] entryArray = this.entries;
            this.entries = new ConstantPool.Entry[this.size];
            System.arraycopy((Object)entryArray, 0, (Object)this.entries, 0, this.size);
        }
        if ((n = this.bigDescs[0]) == 1) {
            this.bigDescs = noBigDescs;
        } else if (n != this.bigDescs.length) {
            int[] nArray = this.bigDescs;
            this.bigDescs = new int[n];
            System.arraycopy((Object)nArray, 0, (Object)this.bigDescs, 0, n);
        }
    }

    public void visitRefs(Collection<ConstantPool.Entry> collection) {
        for (int i = 0; i < this.size; ++i) {
            collection.add(this.entries[i]);
        }
    }

    @Override
    public void clear() {
        if (this.bytes != null) {
            for (Fixup fixup : this) {
                this.storeIndex(fixup.location(), fixup.format(), 0);
            }
        }
        this.size = 0;
        if (this.bigDescs != noBigDescs) {
            this.bigDescs[0] = 1;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        if (this.bytes == byArray) {
            return;
        }
        ArrayList<Fixup> arrayList = null;
        assert ((arrayList = new ArrayList<Fixup>(this)) != null);
        if (this.bytes == null || byArray == null) {
            ArrayList<Fixup> arrayList2 = new ArrayList<Fixup>(this);
            this.clear();
            this.bytes = byArray;
            this.addAll((Collection<? extends Fixup>)arrayList2);
        } else {
            this.bytes = byArray;
        }
        assert (arrayList.equals(new ArrayList<Fixup>(this)));
    }

    static int fmtLen(int n) {
        return 1 + (n - 1) / -1;
    }

    static int descLoc(int n) {
        return n >>> 1;
    }

    static int descFmt(int n) {
        return n & 1;
    }

    static int descEnd(int n) {
        return Fixups.descLoc(n) + Fixups.fmtLen(Fixups.descFmt(n));
    }

    static int makeDesc(int n, int n2) {
        int n3 = n << 1 | n2;
        assert (Fixups.descLoc(n3) == n);
        assert (Fixups.descFmt(n3) == n2);
        return n3;
    }

    int fetchDesc(int n, int n2) {
        int n3;
        byte by = this.bytes[n];
        assert (by != -1);
        if (n2 == 0) {
            byte by2 = this.bytes[n + 1];
            n3 = ((by & 0xFF) << 8) + (by2 & 0xFF);
        } else {
            n3 = by & 0xFF;
        }
        return n3 + (n << 1);
    }

    boolean storeDesc(int n, int n2, int n3) {
        if (this.bytes == null) {
            return false;
        }
        int n4 = n3 - (n << 1);
        switch (n2) {
            case 0: {
                assert (this.bytes[n + 0] == 0);
                assert (this.bytes[n + 1] == 0);
                byte by = (byte)(n4 >> 8);
                byte by2 = (byte)(n4 >> 0);
                if (n4 != (n4 & 0xFFFF) || by == -1) break;
                this.bytes[n + 0] = by;
                this.bytes[n + 1] = by2;
                assert (this.fetchDesc(n, n2) == n3);
                return true;
            }
            case 1: {
                assert (this.bytes[n] == 0);
                byte by = (byte)n4;
                if (n4 != (n4 & 0xFF) || by == -1) break;
                this.bytes[n] = by;
                assert (this.fetchDesc(n, n2) == n3);
                return true;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.bytes[n] = -1;
        assert (n2 == 1 || (this.bytes[n + 1] = (byte)this.bigDescs[0]) != 999);
        return false;
    }

    void storeIndex(int n, int n2, int n3) {
        Fixups.storeIndex(this.bytes, n, n2, n3);
    }

    static void storeIndex(byte[] byArray, int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                assert (n3 == (n3 & 0xFFFF)) : n3;
                byArray[n + 0] = (byte)(n3 >> 8);
                byArray[n + 1] = (byte)(n3 >> 0);
                break;
            }
            case 1: {
                assert (n3 == (n3 & 0xFF)) : n3;
                byArray[n] = (byte)n3;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void addU1(int n, ConstantPool.Entry entry) {
        this.add(n, 1, entry);
    }

    void addU2(int n, ConstantPool.Entry entry) {
        this.add(n, 0, entry);
    }

    @Override
    public Iterator<Fixup> iterator() {
        return new Itr();
    }

    public void add(int n, int n2, ConstantPool.Entry entry) {
        this.addDesc(Fixups.makeDesc(n, n2), entry);
    }

    @Override
    public boolean add(Fixup fixup) {
        this.addDesc(fixup.desc, fixup.entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Fixup> collection) {
        if (collection instanceof Fixups) {
            Fixups fixups = (Fixups)collection;
            if (fixups.size == 0) {
                return false;
            }
            if (this.size == 0 && this.entries.length < fixups.size) {
                this.growEntries(fixups.size);
            }
            ConstantPool.Entry[] entryArray = fixups.entries;
            Fixups fixups2 = fixups;
            fixups2.getClass();
            Itr itr = fixups2.new Itr();
            while (itr.hasNext()) {
                int n = itr.index;
                this.addDesc(itr.nextDesc(), entryArray[n]);
            }
            return true;
        }
        return super.addAll(collection);
    }

    private void addDesc(int n, ConstantPool.Entry entry) {
        if (this.entries.length == this.size) {
            this.growEntries(this.size * 2);
        }
        this.entries[this.size] = entry;
        if (this.size == 0) {
            this.head = this.tail = n;
        } else {
            int n2 = this.tail;
            int n3 = Fixups.descLoc(n2);
            int n4 = Fixups.descFmt(n2);
            int n5 = Fixups.fmtLen(n4);
            int n6 = Fixups.descLoc(n);
            if (n6 < n3 + n5) {
                this.badOverlap(n6);
            }
            this.tail = n;
            if (!this.storeDesc(n3, n4, n)) {
                int n7 = this.bigDescs[0];
                if (this.bigDescs.length == n7) {
                    this.growBigDescs();
                }
                this.bigDescs[n7++] = n;
                this.bigDescs[0] = n7;
            }
        }
        ++this.size;
    }

    private void badOverlap(int n) {
        throw new IllegalArgumentException("locs must be ascending and must not overlap:  " + n + " >> " + this);
    }

    private void growEntries(int n) {
        ConstantPool.Entry[] entryArray = this.entries;
        this.entries = new ConstantPool.Entry[Math.max(3, n)];
        System.arraycopy((Object)entryArray, 0, (Object)this.entries, 0, entryArray.length);
    }

    private void growBigDescs() {
        int[] nArray = this.bigDescs;
        this.bigDescs = new int[nArray.length * 2];
        System.arraycopy((Object)nArray, 0, (Object)this.bigDescs, 0, nArray.length);
    }

    static Object addRefWithBytes(Object object, byte[] byArray, ConstantPool.Entry entry) {
        return Fixups.add(object, byArray, 0, 0, entry);
    }

    static Object addRefWithLoc(Object object, int n, ConstantPool.Entry entry) {
        return Fixups.add(object, null, n, 0, entry);
    }

    private static Object add(Object object, byte[] byArray, int n, int n2, ConstantPool.Entry entry) {
        Fixups fixups;
        if (object == null) {
            if (n == 0 && n2 == 0) {
                return entry;
            }
            fixups = new Fixups(byArray);
        } else if (!(object instanceof Fixups)) {
            ConstantPool.Entry entry2 = (ConstantPool.Entry)object;
            fixups = new Fixups(byArray);
            fixups.add(0, 0, entry2);
        } else {
            fixups = (Fixups)object;
            assert (fixups.bytes == byArray);
        }
        fixups.add(n, n2, entry);
        return fixups;
    }

    public static void setBytes(Object object, byte[] byArray) {
        if (object instanceof Fixups) {
            Fixups fixups = (Fixups)object;
            fixups.setBytes(byArray);
        }
    }

    public static Object trimToSize(Object object) {
        if (object instanceof Fixups) {
            Fixups fixups = (Fixups)object;
            fixups.trimToSize();
            if (fixups.size() == 0) {
                object = null;
            }
        }
        return object;
    }

    public static void visitRefs(Object object, Collection<ConstantPool.Entry> collection) {
        if (object != null) {
            if (!(object instanceof Fixups)) {
                collection.add((ConstantPool.Entry)object);
            } else {
                Fixups fixups = (Fixups)object;
                fixups.visitRefs(collection);
            }
        }
    }

    public static void finishRefs(Object object, byte[] byArray, ConstantPool.Index index) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Fixups)) {
            int n = index.indexOf((ConstantPool.Entry)object);
            Fixups.storeIndex(byArray, 0, 0, n);
            return;
        }
        Fixups fixups = (Fixups)object;
        assert (fixups.bytes == byArray);
        fixups.finishRefs(index);
    }

    void finishRefs(ConstantPool.Index index) {
        if (this.isEmpty()) {
            return;
        }
        for (Fixup fixup : this) {
            int n = index.indexOf(fixup.entry);
            this.storeIndex(fixup.location(), fixup.format(), n);
        }
        this.bytes = null;
        this.clear();
    }

    private class Itr
    implements Iterator<Fixup> {
        int index = 0;
        int bigIndex = 1;
        int next;

        private Itr() {
            this.next = Fixups.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.index < Fixups.this.size;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Fixup next() {
            int n = this.index;
            return new Fixup(this.nextDesc(), Fixups.this.entries[n]);
        }

        int nextDesc() {
            ++this.index;
            int n = this.next;
            if (this.index < Fixups.this.size) {
                int n2 = Fixups.descLoc(n);
                int n3 = Fixups.descFmt(n);
                if (Fixups.this.bytes != null && Fixups.this.bytes[n2] != -1) {
                    this.next = Fixups.this.fetchDesc(n2, n3);
                } else {
                    assert (n3 == 1 || Fixups.this.bytes == null || Fixups.this.bytes[n2 + 1] == (byte)this.bigIndex);
                    this.next = Fixups.this.bigDescs[this.bigIndex++];
                }
            }
            return n;
        }
    }

    public static class Fixup
    implements Comparable<Fixup> {
        int desc;
        ConstantPool.Entry entry;

        Fixup(int n, ConstantPool.Entry entry) {
            this.desc = n;
            this.entry = entry;
        }

        public Fixup(int n, int n2, ConstantPool.Entry entry) {
            this.desc = Fixups.makeDesc(n, n2);
            this.entry = entry;
        }

        public int location() {
            return Fixups.descLoc(this.desc);
        }

        public int format() {
            return Fixups.descFmt(this.desc);
        }

        public ConstantPool.Entry entry() {
            return this.entry;
        }

        @Override
        public int compareTo(Fixup fixup) {
            return this.location() - fixup.location();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Fixup)) {
                return false;
            }
            Fixup fixup = (Fixup)object;
            return this.desc == fixup.desc && this.entry == fixup.entry;
        }

        public int hashCode() {
            int n = 7;
            n = 59 * n + this.desc;
            n = 59 * n + Objects.hashCode(this.entry);
            return n;
        }

        public String toString() {
            return "@" + this.location() + (this.format() == 1 ? ".1" : "") + "=" + this.entry;
        }
    }
}

