/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.CannotSetClasspathException;
import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import com.ibm.oti.util.Msg;
import java.net.URL;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class SharedClassURLClasspathHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLClasspathHelper {
    private URL[] urls;
    private URL[] origurls;
    private boolean[] validated;
    private int urlCount;
    private int confirmedCount;
    private boolean invalidURLExists;
    private ReentrantReadWriteLock urlcpReadWriteLock;

    private static native void init();

    SharedClassURLClasspathHelperImpl(ClassLoader classLoader, URL[] uRLArray, int n, boolean bl, boolean bl2) {
        this.origurls = uRLArray;
        this.urls = new URL[uRLArray.length];
        this.urlCount = uRLArray.length;
        this.validated = new boolean[uRLArray.length];
        this.confirmedCount = 0;
        this.invalidURLExists = false;
        this.urlcpReadWriteLock = new ReentrantReadWriteLock();
        this.initialize(classLoader, n, bl, bl2);
        this.initializeShareableClassloader(classLoader);
        this.initializeURLs();
        if (!this.invalidURLExists) {
            this.notifyClasspathChange3(n, classLoader, this.urls, 0, this.urlCount, true);
        }
    }

    private void initializeURLs() {
        for (int i = 0; i < this.urlCount; ++i) {
            this.urls[i] = this.convertJarURL(this.origurls[i]);
            if (this.validateURL(this.urls[i], false)) continue;
            this.invalidURLExists = true;
        }
    }

    private native int findSharedClassImpl2(int var1, String var2, String var3, ClassLoader var4, URL[] var5, boolean var6, boolean var7, int var8, int var9, byte[] var10);

    private native boolean storeSharedClassImpl2(int var1, String var2, ClassLoader var3, URL[] var4, int var5, int var6, Class<?> var7, byte[] var8);

    private native void notifyClasspathChange2(ClassLoader var1);

    private native void notifyClasspathChange3(int var1, ClassLoader var2, URL[] var3, int var4, int var5, boolean var6);

    @Override
    public byte[] findSharedClass(String string, SharedClassURLClasspathHelper.IndexHolder indexHolder) {
        return this.findSharedClass(null, string, indexHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] findSharedClass(String string, String string2, SharedClassURLClasspathHelper.IndexHolder indexHolder) {
        boolean bl;
        boolean bl2;
        Object object;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (string2 == null) {
            this.printVerboseError(Msg.getString("K05a1"));
            return null;
        }
        SharedClassFilter sharedClassFilter = this.getSharingFilter();
        if (sharedClassFilter != null) {
            object = this;
            synchronized (object) {
                bl2 = sharedClassFilter.acceptFind(string2);
                bl = nativeFlags[0] == 0 ? sharedClassFilter.acceptStore(string2) : true;
            }
        } else {
            bl2 = true;
            bl = true;
        }
        object = new byte[this.ROMCLASS_COOKIE_SIZE];
        int n = -1;
        this.urlcpReadWriteLock.readLock().lock();
        try {
            if (this.invalidURLExists) {
                this.printVerboseInfo(Msg.getString("K05a4"));
                byte[] byArray = null;
                return byArray;
            }
            if (this.confirmedCount == 0) {
                this.printVerboseInfo(Msg.getString("K05a5"));
                byte[] byArray = null;
                return byArray;
            }
            n = this.findSharedClassImpl2(this.id, string, string2, classLoader, this.urls, bl2, bl, this.urlCount, this.confirmedCount, (byte[])object);
        }
        finally {
            this.urlcpReadWriteLock.readLock().unlock();
        }
        if (n < 0) {
            return null;
        }
        if (indexHolder != null) {
            indexHolder.setIndex(n);
        }
        return object;
    }

    @Override
    public boolean storeSharedClass(Class<?> clazz, int n) {
        return this.storeSharedClass(null, clazz, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeSharedClass(String string, Class<?> clazz, int n) {
        if (!this.canStore) {
            return false;
        }
        if (clazz == null) {
            this.printVerboseError(Msg.getString("K05a3"));
            return false;
        }
        if (n < 0) {
            this.printVerboseError(Msg.getString("K05a7"));
            return false;
        }
        ClassLoader classLoader = this.getClassLoader();
        if (!this.validateClassLoader(classLoader, clazz)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        this.urlcpReadWriteLock.readLock().lock();
        try {
            if (this.urlCount == 0) {
                this.printVerboseError(Msg.getString("K05a6"));
                boolean bl3 = false;
                return bl3;
            }
            if (n >= this.urlCount) {
                this.printVerboseError(Msg.getString("K05a8"));
                boolean bl4 = false;
                return bl4;
            }
            if (this.invalidURLExists) {
                this.printVerboseInfo(Msg.getString("K05a9"));
                boolean bl5 = false;
                return bl5;
            }
            if (!this.validated[n]) {
                if (!this.validateURL(this.urls[n], true)) {
                    boolean bl6 = false;
                    return bl6;
                }
                this.validated[n] = true;
            }
            if (this.confirmedCount <= n) {
                bl2 = true;
            }
            bl = this.storeSharedClassImpl2(this.id, string, classLoader, this.urls, this.urlCount, n, clazz, nativeFlags);
        }
        finally {
            this.urlcpReadWriteLock.readLock().unlock();
        }
        if (bl2) {
            this.increaseConfirmedCount(n + 1);
        }
        return bl;
    }

    private void growURLs(int n) {
        if (!this.urlcpReadWriteLock.writeLock().isHeldByCurrentThread()) {
            throw new InternalError();
        }
        this.printVerboseInfo(Msg.getString("K05ab", n));
        int n2 = (n + 1) * 2;
        URL[] uRLArray = new URL[n2];
        URL[] uRLArray2 = new URL[n2];
        boolean[] blArray = new boolean[n2];
        System.arraycopy((Object)this.origurls, 0, (Object)uRLArray, 0, this.urlCount);
        System.arraycopy((Object)this.urls, 0, (Object)uRLArray2, 0, this.urlCount);
        System.arraycopy((Object)this.validated, 0, (Object)blArray, 0, this.urlCount);
        this.origurls = uRLArray;
        this.urls = uRLArray2;
        this.validated = blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClasspathEntry(URL uRL) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            if (uRL == null) {
                this.printVerboseError(Msg.getString("K05ac"));
                return;
            }
            URL uRL2 = this.convertJarURL(uRL);
            boolean bl = false;
            if (!this.validateURL(uRL2, false)) {
                bl = true;
            }
            this.urlcpReadWriteLock.writeLock().lock();
            try {
                if (this.urls.length < this.urlCount + 1) {
                    this.growURLs(this.urlCount + 1);
                }
                this.origurls[this.urlCount] = uRL;
                this.urls[this.urlCount] = uRL2;
                this.invalidURLExists = bl;
                this.notifyClasspathChange2(classLoader);
                if (!this.invalidURLExists) {
                    this.notifyClasspathChange3(this.id, classLoader, this.urls, this.urlCount, this.urlCount + 1, true);
                }
                ++this.urlCount;
            }
            finally {
                this.urlcpReadWriteLock.writeLock().unlock();
            }
        }
    }

    URL[] getClasspath() {
        URL[] uRLArray = new URL[this.urlCount];
        this.urlcpReadWriteLock.readLock().lock();
        try {
            System.arraycopy((Object)this.origurls, 0, (Object)uRLArray, 0, this.urlCount);
        }
        finally {
            this.urlcpReadWriteLock.readLock().unlock();
        }
        return uRLArray;
    }

    private void increaseConfirmedCount(int n) {
        this.urlcpReadWriteLock.writeLock().lock();
        try {
            if (n > this.confirmedCount) {
                this.confirmedCount = n;
                this.printVerboseInfo(Msg.getString("K05aa", this.confirmedCount));
            }
        }
        finally {
            this.urlcpReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void confirmAllEntries() {
        this.urlcpReadWriteLock.writeLock().lock();
        try {
            this.confirmedCount = this.urlCount;
        }
        finally {
            this.urlcpReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClasspath(URL[] uRLArray) throws CannotSetClasspathException {
        boolean bl = false;
        boolean bl2 = false;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new CannotSetClasspathException(Msg.getString("K059a"));
        }
        this.urlcpReadWriteLock.writeLock().lock();
        try {
            int n;
            int n2;
            int n3 = n2 = this.origurls.length < uRLArray.length ? this.origurls.length : uRLArray.length;
            if (uRLArray.length < this.confirmedCount) {
                throw new CannotSetClasspathException(Msg.getString("K05ad"));
            }
            for (n = 0; n < this.confirmedCount; ++n) {
                if (uRLArray[n].equals(this.origurls[n])) continue;
                throw new CannotSetClasspathException(Msg.getString("K05ae", n));
            }
            if (uRLArray.length > this.origurls.length) {
                this.growURLs(uRLArray.length);
            }
            for (n = this.confirmedCount; n < n2; ++n) {
                boolean bl3;
                boolean bl4 = bl3 = !uRLArray[n].equals(this.origurls[n]);
                if (!this.invalidURLExists && !bl3) continue;
                URL uRL = null;
                uRL = bl3 ? this.convertJarURL(uRLArray[n]) : this.urls[n];
                if (!bl2 && !this.validateURL(uRL, false)) {
                    bl2 = true;
                    this.printVerboseInfo(Msg.getString("K05af", uRLArray[n], n));
                }
                if (!bl3) continue;
                this.origurls[n] = uRLArray[n];
                this.urls[n] = uRL;
                bl = true;
            }
            this.invalidURLExists = bl2;
            for (n = n2; n < uRLArray.length; ++n) {
                this.origurls[n] = uRLArray[n];
                this.urls[n] = this.convertJarURL(uRLArray[n]);
                if (!this.invalidURLExists && !this.validateURL(this.urls[n], false)) {
                    this.printVerboseInfo(Msg.getString("K05b0", uRLArray[n], n));
                    this.invalidURLExists = true;
                }
                bl = true;
            }
            if (this.urlCount != uRLArray.length) {
                this.urlCount = uRLArray.length;
                bl = true;
            }
            if (!this.invalidURLExists) {
                this.printVerboseInfo(Msg.getString("K05b1"));
            }
            if (bl) {
                this.printVerboseInfo(Msg.getString("K05b2", this.urlCount));
                this.notifyClasspathChange2(classLoader);
                if (!this.invalidURLExists) {
                    this.notifyClasspathChange3(this.id, classLoader, this.urls, 0, this.urlCount, true);
                }
            }
        }
        finally {
            this.urlcpReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    String getHelperType() {
        return "SharedClassURLClasspathHelper";
    }

    static {
        SharedClassURLClasspathHelperImpl.init();
    }
}

