/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

public final class ByteArrayUnmarshaller {
    private ByteArrayUnmarshaller() {
    }

    public static short readShort(byte[] byArray, int n, boolean bl) {
        if (n + 2 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readShort is trying to access byteArray[" + n + "] and byteArray[" + (n + 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            return ByteArrayUnmarshaller.readShort_(byArray, n, true);
        }
        return ByteArrayUnmarshaller.readShort_(byArray, n, false);
    }

    private static short readShort_(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
        }
        return (short)((byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    public static short readShort(byte[] byArray, int n, boolean bl, int n2, boolean bl2) {
        if (n + n2 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Access offset must be positive or zero and last byte must be in range.");
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("numBytes == " + n2);
        }
        if (bl) {
            if (bl2) {
                return ByteArrayUnmarshaller.readShort_(byArray, n, true, n2, true);
            }
            return ByteArrayUnmarshaller.readShort_(byArray, n, true, n2, false);
        }
        if (bl2) {
            return ByteArrayUnmarshaller.readShort_(byArray, n, false, n2, true);
        }
        return ByteArrayUnmarshaller.readShort_(byArray, n, false, n2, false);
    }

    private static short readShort_(byte[] byArray, int n, boolean bl, int n2, boolean bl2) {
        int n3 = n;
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                if (bl2) {
                    return byArray[n3];
                }
                return (short)(byArray[n3] & 0xFF);
            }
            case 2: {
                if (bl) {
                    return (short)((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF);
                }
                return (short)((byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF);
            }
        }
        return 0;
    }

    public static int readInt(byte[] byArray, int n, boolean bl) {
        if (n + 4 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readInt is trying to access byteArray[" + n + "] to byteArray[" + (n + 3) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            return ByteArrayUnmarshaller.readInt_(byArray, n, true);
        }
        return ByteArrayUnmarshaller.readInt_(byArray, n, false);
    }

    private static int readInt_(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        }
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int readInt(byte[] byArray, int n, boolean bl, int n2, boolean bl2) {
        if (n + n2 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Access offset must be positive or zero and last byte must be in range.");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("numBytes == " + n2);
        }
        if (bl) {
            if (bl2) {
                return ByteArrayUnmarshaller.readInt_(byArray, n, true, n2, true);
            }
            return ByteArrayUnmarshaller.readInt_(byArray, n, true, n2, false);
        }
        if (bl2) {
            return ByteArrayUnmarshaller.readInt_(byArray, n, false, n2, true);
        }
        return ByteArrayUnmarshaller.readInt_(byArray, n, false, n2, false);
    }

    private static int readInt_(byte[] byArray, int n, boolean bl, int n2, boolean bl2) {
        int n3 = n;
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                if (bl2) {
                    return byArray[n3];
                }
                return byArray[n3] & 0xFF;
            }
            case 2: {
                int n4 = bl ? (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF : (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF;
                if (bl2) {
                    return (short)n4;
                }
                return n4 & 0xFFFF;
            }
            case 3: {
                int n5 = bl ? (byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF : (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF;
                if (bl2 && (n5 & 0x800000) != 0) {
                    n5 |= 0xFF000000;
                }
                return n5;
            }
            case 4: {
                if (bl) {
                    return (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
                }
                return (byArray[n3 + 3] & 0xFF) << 24 | (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF;
            }
        }
        return 0;
    }

    public static long readLong(byte[] byArray, int n, boolean bl) {
        if (n + 8 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readLong is trying to access byteArray[" + n + "] to byteArray[" + (n + 7) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            return ByteArrayUnmarshaller.readLong_(byArray, n, true);
        }
        return ByteArrayUnmarshaller.readLong_(byArray, n, false);
    }

    private static long readLong_(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return (long)(byArray[n] & 0xFF) << 56 | (long)(byArray[n + 1] & 0xFF) << 48 | (long)(byArray[n + 2] & 0xFF) << 40 | (long)(byArray[n + 3] & 0xFF) << 32 | (long)(byArray[n + 4] & 0xFF) << 24 | (long)((byArray[n + 5] & 0xFF) << 16) | (long)((byArray[n + 6] & 0xFF) << 8) | (long)(byArray[n + 7] & 0xFF);
        }
        return (long)(byArray[n + 7] & 0xFF) << 56 | (long)(byArray[n + 6] & 0xFF) << 48 | (long)(byArray[n + 5] & 0xFF) << 40 | (long)(byArray[n + 4] & 0xFF) << 32 | (long)(byArray[n + 3] & 0xFF) << 24 | (long)((byArray[n + 2] & 0xFF) << 16) | (long)((byArray[n + 1] & 0xFF) << 8) | (long)(byArray[n] & 0xFF);
    }

    public static long readLong(byte[] byArray, int n, boolean bl, int n2, boolean bl2) {
        if (n + n2 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Access offset must be positive or zero and last byte must be in range.");
        }
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("numBytes == " + n2);
        }
        if (bl) {
            if (bl2) {
                return ByteArrayUnmarshaller.readLong_(byArray, n, true, n2, true);
            }
            return ByteArrayUnmarshaller.readLong_(byArray, n, true, n2, false);
        }
        if (bl2) {
            return ByteArrayUnmarshaller.readLong_(byArray, n, false, n2, true);
        }
        return ByteArrayUnmarshaller.readLong_(byArray, n, false, n2, false);
    }

    private static long readLong_(byte[] byArray, int n, boolean bl, int n2, boolean bl2) {
        int n3 = n;
        switch (n2) {
            case 0: {
                return 0L;
            }
            case 1: {
                if (bl2) {
                    return byArray[n3];
                }
                return (long)byArray[n3] & 0xFFL;
            }
            case 2: {
                long l = bl ? (long)((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF) : (long)((byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF);
                if (bl2) {
                    return (short)l;
                }
                return l & 0xFFFFL;
            }
            case 3: {
                long l = bl ? (long)((byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF) : (long)((byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF);
                if (bl2) {
                    l = l << 40 >> 40;
                }
                return l;
            }
            case 4: {
                long l = bl ? ((long)byArray[n3] & 0xFFL) << 24 | (long)((byArray[n3 + 1] & 0xFF) << 16) | (long)((byArray[n3 + 2] & 0xFF) << 8) | (long)(byArray[n3 + 3] & 0xFF) : ((long)byArray[n3 + 3] & 0xFFL) << 24 | (long)((byArray[n3 + 2] & 0xFF) << 16) | (long)((byArray[n3 + 1] & 0xFF) << 8) | (long)(byArray[n3] & 0xFF);
                if (bl2) {
                    l = l << 32 >> 32;
                }
                return l;
            }
            case 5: {
                long l = bl ? ((long)byArray[n3] & 0xFFL) << 32 | ((long)byArray[n3 + 1] & 0xFFL) << 24 | (long)((byArray[n3 + 2] & 0xFF) << 16) | (long)((byArray[n3 + 3] & 0xFF) << 8) | (long)(byArray[n3 + 4] & 0xFF) : ((long)byArray[n3 + 4] & 0xFFL) << 32 | ((long)byArray[n3 + 3] & 0xFFL) << 24 | (long)((byArray[n3 + 2] & 0xFF) << 16) | (long)((byArray[n3 + 1] & 0xFF) << 8) | (long)(byArray[n3] & 0xFF);
                if (bl2) {
                    l = l << 24 >> 24;
                }
                return l;
            }
            case 6: {
                long l = bl ? ((long)byArray[n3] & 0xFFL) << 40 | ((long)byArray[n3 + 1] & 0xFFL) << 32 | ((long)byArray[n3 + 2] & 0xFFL) << 24 | (long)((byArray[n3 + 3] & 0xFF) << 16) | (long)((byArray[n3 + 4] & 0xFF) << 8) | (long)(byArray[n3 + 5] & 0xFF) : ((long)byArray[n3 + 5] & 0xFFL) << 40 | ((long)byArray[n3 + 4] & 0xFFL) << 32 | ((long)byArray[n3 + 3] & 0xFFL) << 24 | (long)((byArray[n3 + 2] & 0xFF) << 16) | (long)((byArray[n3 + 1] & 0xFF) << 8) | (long)(byArray[n3] & 0xFF);
                if (bl2) {
                    l = l << 16 >> 16;
                }
                return l;
            }
            case 7: {
                long l = bl ? ((long)byArray[n3] & 0xFFL) << 48 | ((long)byArray[n3 + 1] & 0xFFL) << 40 | ((long)byArray[n3 + 2] & 0xFFL) << 32 | ((long)byArray[n3 + 3] & 0xFFL) << 24 | (long)((byArray[n3 + 4] & 0xFF) << 16) | (long)((byArray[n3 + 5] & 0xFF) << 8) | (long)(byArray[n3 + 6] & 0xFF) : ((long)byArray[n3 + 6] & 0xFFL) << 48 | ((long)byArray[n3 + 5] & 0xFFL) << 40 | ((long)byArray[n3 + 4] & 0xFFL) << 32 | ((long)byArray[n3 + 3] & 0xFFL) << 24 | (long)((byArray[n3 + 2] & 0xFF) << 16) | (long)((byArray[n3 + 1] & 0xFF) << 8) | (long)(byArray[n3] & 0xFF);
                if (bl2) {
                    l = l << 8 >> 8;
                }
                return l;
            }
            case 8: {
                if (bl) {
                    return ((long)byArray[n3] & 0xFFL) << 56 | ((long)byArray[n3 + 1] & 0xFFL) << 48 | ((long)byArray[n3 + 2] & 0xFFL) << 40 | ((long)byArray[n3 + 3] & 0xFFL) << 32 | ((long)byArray[n3 + 4] & 0xFFL) << 24 | (long)((byArray[n3 + 5] & 0xFF) << 16) | (long)((byArray[n3 + 6] & 0xFF) << 8) | (long)(byArray[n3 + 7] & 0xFF);
                }
                return ((long)byArray[n3 + 7] & 0xFFL) << 56 | ((long)byArray[n3 + 6] & 0xFFL) << 48 | ((long)byArray[n3 + 5] & 0xFFL) << 40 | ((long)byArray[n3 + 4] & 0xFFL) << 32 | ((long)byArray[n3 + 3] & 0xFFL) << 24 | (long)((byArray[n3 + 2] & 0xFF) << 16) | (long)((byArray[n3 + 1] & 0xFF) << 8) | (long)(byArray[n3] & 0xFF);
            }
        }
        return 0L;
    }

    public static float readFloat(byte[] byArray, int n, boolean bl) {
        if (n + 4 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readFloat is trying to access byteArray[" + n + "] to byteArray[" + (n + 3) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            return ByteArrayUnmarshaller.readFloat_(byArray, n, true);
        }
        return ByteArrayUnmarshaller.readFloat_(byArray, n, false);
    }

    private static float readFloat_(byte[] byArray, int n, boolean bl) {
        return Float.intBitsToFloat(ByteArrayUnmarshaller.readInt(byArray, n, bl));
    }

    public static double readDouble(byte[] byArray, int n, boolean bl) {
        if (n + 8 > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. readDouble is trying to access byteArray[" + n + "] to byteArray[" + (n + 7) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (bl) {
            return ByteArrayUnmarshaller.readDouble_(byArray, n, true);
        }
        return ByteArrayUnmarshaller.readDouble_(byArray, n, false);
    }

    private static double readDouble_(byte[] byArray, int n, boolean bl) {
        return Double.longBitsToDouble(ByteArrayUnmarshaller.readLong(byArray, n, bl));
    }
}

