/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.GHASH;
import com.sun.crypto.provider.SymmetricCipher;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import javax.crypto.AEADBadTagException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import jdk.crypto.jniprovider.NativeCrypto;

final class NativeGaloisCounterMode
extends FeedbackCipher {
    private byte[] key;
    private boolean decrypting;
    private static final byte[] emptyAAD = new byte[0];
    static int DEFAULT_TAG_LEN = 16;
    static int DEFAULT_IV_LEN = 12;
    private static final int MAX_BUF_SIZE = Integer.MAX_VALUE;
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private int sizeOfAAD = 0;
    private ByteArrayOutputStream ibuffer = null;
    private ByteArrayOutputStream ibuffer_enc = null;
    private int tagLenBytes = DEFAULT_TAG_LEN;
    private byte[] subkeyH = null;
    private byte[] preCounterBlock = null;
    private int processed = 0;
    private byte[] aadBufferSave = null;
    private int sizeOfAADSave = 0;
    private byte[] ibufferSave = null;
    private byte[] ibufferSave_enc = null;
    private int processedSave = 0;
    private static NativeCrypto nativeCrypto = NativeCrypto.getNativeCrypto();

    static void increment32(byte[] byArray) {
        if (byArray.length != 16) {
            throw new ProviderException("Illegal counter block length");
        }
        int n = byArray.length - 1;
        while (n >= byArray.length - 4) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
    }

    private static byte[] getLengthBlock(int n) {
        long l = (long)n << 3;
        byte[] byArray = new byte[16];
        byArray[8] = (byte)(l >>> 56);
        byArray[9] = (byte)(l >>> 48);
        byArray[10] = (byte)(l >>> 40);
        byArray[11] = (byte)(l >>> 32);
        byArray[12] = (byte)(l >>> 24);
        byArray[13] = (byte)(l >>> 16);
        byArray[14] = (byte)(l >>> 8);
        byArray[15] = (byte)l;
        return byArray;
    }

    private static byte[] getLengthBlock(int n, int n2) {
        long l = (long)n << 3;
        long l2 = (long)n2 << 3;
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l, (byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
        return byArray;
    }

    private static byte[] expandToOneBlock(byte[] byArray, int n, int n2) {
        if (n2 > 16) {
            throw new ProviderException("input " + n2 + " too long");
        }
        if (n2 == 16 && n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    private static byte[] getJ0(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        if (byArray.length == 12) {
            byArray3 = NativeGaloisCounterMode.expandToOneBlock(byArray, 0, byArray.length);
            byArray3[15] = 1;
        } else {
            byte[] byArray4;
            GHASH gHASH = new GHASH(byArray2);
            int n = byArray.length % 16;
            if (n != 0) {
                gHASH.update(byArray, 0, byArray.length - n);
                byArray4 = NativeGaloisCounterMode.expandToOneBlock(byArray, byArray.length - n, n);
                gHASH.update(byArray4);
            } else {
                gHASH.update(byArray);
            }
            byArray4 = NativeGaloisCounterMode.getLengthBlock(byArray.length);
            gHASH.update(byArray4);
            byArray3 = gHASH.digest();
        }
        return byArray3;
    }

    private static void checkDataLength(int n, int n2) {
        if (n > Integer.MAX_VALUE - n2) {
            throw new ProviderException("SunJCE provider only supports input size up to 2147483647 bytes");
        }
    }

    NativeGaloisCounterMode(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
        this.aadBuffer = new ByteArrayOutputStream();
    }

    @Override
    String getFeedback() {
        return "GCM";
    }

    @Override
    synchronized void reset() {
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        this.processed = 0;
        this.sizeOfAAD = 0;
        if (this.ibuffer != null) {
            this.ibuffer.reset();
        }
        if (this.ibuffer_enc != null) {
            this.ibuffer_enc.reset();
        }
    }

    @Override
    synchronized void save() {
        this.processedSave = this.processed;
        this.sizeOfAADSave = this.sizeOfAAD;
        byte[] byArray = this.aadBufferSave = this.aadBuffer == null || this.aadBuffer.size() == 0 ? null : this.aadBuffer.toByteArray();
        if (this.ibuffer != null) {
            this.ibufferSave = this.ibuffer.toByteArray();
        }
        if (this.ibuffer_enc != null) {
            this.ibufferSave_enc = this.ibuffer_enc.toByteArray();
        }
    }

    @Override
    synchronized void restore() {
        this.processed = this.processedSave;
        this.sizeOfAAD = this.sizeOfAADSave;
        if (this.aadBuffer != null) {
            this.aadBuffer.reset();
            if (this.aadBufferSave != null) {
                this.aadBuffer.write(this.aadBufferSave, 0, this.aadBufferSave.length);
            }
        }
        if (this.ibuffer != null && this.ibufferSave != null) {
            this.ibuffer.reset();
            this.ibuffer.write(this.ibufferSave, 0, this.ibufferSave.length);
        }
        if (this.ibuffer_enc != null && this.ibufferSave_enc != null) {
            this.ibuffer_enc.reset();
            this.ibuffer_enc.write(this.ibufferSave_enc, 0, this.ibufferSave_enc.length);
        }
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        this.init(bl, string, byArray, byArray2, DEFAULT_TAG_LEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2, int n) throws InvalidKeyException {
        if (byArray == null || byArray2 == null) {
            throw new InvalidKeyException("Internal error");
        }
        if (!AESCrypt.isKeySizeValid(byArray.length)) {
            throw new InvalidKeyException("Invalid AES key length: " + byArray.length + " bytes");
        }
        NativeGaloisCounterMode nativeGaloisCounterMode = this;
        synchronized (nativeGaloisCounterMode) {
            this.key = (byte[])byArray.clone();
            this.iv = (byte[])byArray2.clone();
            this.tagLenBytes = n;
            this.decrypting = bl;
            if (this.aadBuffer == null) {
                this.aadBuffer = new ByteArrayOutputStream();
            } else {
                this.aadBuffer.reset();
            }
            if (bl) {
                this.ibuffer = new ByteArrayOutputStream();
            } else {
                this.ibuffer_enc = new ByteArrayOutputStream();
            }
        }
    }

    @Override
    synchronized void updateAAD(byte[] byArray, int n, int n2) {
        if (this.aadBuffer == null) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        NativeGaloisCounterMode nativeGaloisCounterMode = this;
        synchronized (nativeGaloisCounterMode) {
            NativeGaloisCounterMode.checkDataLength(this.ibuffer_enc.size(), n2);
            if (n2 > 0) {
                this.ibuffer_enc.write(byArray, n, n2);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int encryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException {
        int n4;
        int n5;
        NativeGaloisCounterMode nativeGaloisCounterMode = this;
        synchronized (nativeGaloisCounterMode) {
            n5 = this.tagLenBytes;
            if (n2 > Integer.MAX_VALUE - n5) {
                throw new ShortBufferException("Can't fit both data and tag into one buffer");
            }
            if (n2 != 0) {
                this.ibuffer_enc.write(byArray, n, n2);
            }
            byArray = this.ibuffer_enc.toByteArray();
            n = 0;
            n2 = byArray.length;
            this.ibuffer_enc.reset();
            if (byArray2.length - n3 < n2 + n5) {
                throw new ShortBufferException("Output buffer too small");
            }
            byte[] byArray3 = this.aadBuffer == null || this.aadBuffer.size() == 0 ? emptyAAD : this.aadBuffer.toByteArray();
            n4 = nativeCrypto.GCMEncrypt(this.key, this.key.length, this.iv, this.iv.length, byArray, n, n2, byArray2, n3, byArray3, byArray3.length, n5);
        }
        if (n4 == -1) {
            throw new ProviderException("Error in Native GaloisCounterMode");
        }
        return n2 + n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        NativeGaloisCounterMode nativeGaloisCounterMode = this;
        synchronized (nativeGaloisCounterMode) {
            NativeGaloisCounterMode.checkDataLength(this.ibuffer.size(), n2);
            if (n2 > 0) {
                this.ibuffer.write(byArray, n, n2);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        int n4;
        NativeGaloisCounterMode nativeGaloisCounterMode = this;
        synchronized (nativeGaloisCounterMode) {
            if (n2 < this.tagLenBytes) {
                throw new AEADBadTagException("Input too short - need tag");
            }
            NativeGaloisCounterMode.checkDataLength(this.ibuffer.size(), n2 - this.tagLenBytes);
            if (byArray2.length - n3 < this.ibuffer.size() + n2 - this.tagLenBytes) {
                throw new ShortBufferException("Output buffer too small");
            }
            byte[] byArray3 = this.aadBuffer == null || this.aadBuffer.size() == 0 ? emptyAAD : this.aadBuffer.toByteArray();
            this.aadBuffer = null;
            if (n2 != 0) {
                this.ibuffer.write(byArray, n, n2);
            }
            byArray = this.ibuffer.toByteArray();
            n = 0;
            n2 = byArray.length;
            this.ibuffer.reset();
            n4 = nativeCrypto.GCMDecrypt(this.key, this.key.length, this.iv, this.iv.length, byArray, n, n2, byArray2, n3, byArray3, byArray3.length, this.tagLenBytes);
        }
        if (n4 == -2) {
            throw new AEADBadTagException("Tag mismatch!");
        }
        if (n4 == -1) {
            throw new ProviderException("Error in Native GaloisCounterMode");
        }
        return n4;
    }

    int getTagLen() {
        return this.tagLenBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getBufferedLength() {
        NativeGaloisCounterMode nativeGaloisCounterMode = this;
        synchronized (nativeGaloisCounterMode) {
            if (this.ibuffer != null && this.decrypting) {
                return this.ibuffer.size();
            }
            if (this.ibuffer_enc != null && !this.decrypting) {
                return this.ibuffer_enc.size();
            }
        }
        return 0;
    }
}

