/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLInputStream
extends InputStream
implements ResourceReleaser {
    private InputStream in = null;
    private static final int BUFFER_SIZE = 4096;
    private char[] buffer = new char[4096];
    private InputStreamReader reader = null;
    private OutputStreamWriter writer = null;
    private int index = 0;
    private int indexMax = 0;
    private boolean eos = false;
    private static final String CHARSET_NAME = "UTF-8";
    private int[] utf8Data = new int[3];
    private int utf8Index = 0;
    private int utf8MaxIndex = -1;
    private static final int STATE_START_TAG = 1;
    private static final int STATE_CLOSE_TAG = 2;
    private static final int STATE_CONTENTS = 3;
    private static final int STATE_ATTRIBUTES = 4;
    private static final int STATE_ATTRIBUTE_CONTENTS = 5;
    private static final int STATE_INSERT_MISSING_CLOSING_TAG = 6;
    private static final int STATE_INSERT_MISSING_CLOSING_TAG_ROOT = 7;
    private int state = 3;
    private Stack tags = new Stack();
    private StringBuffer name = null;
    private String peekName = null;
    private StringBuffer missingDataBuffer = null;
    private int missingDataIndex = 0;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private boolean outputWritten = false;
    private File temp = null;
    private FileOutputStream fout = null;

    public XMLInputStream(InputStream inputStream) {
        this.log.fine("Cleaning xml input stream");
        this.in = inputStream;
        try {
            this.reader = new InputStreamReader(inputStream, CHARSET_NAME);
            this.writer = new OutputStreamWriter(new OutputStream(){

                @Override
                public void write(int n) throws IOException {
                    ((XMLInputStream)XMLInputStream.this).utf8Data[++((XMLInputStream)XMLInputStream.this).utf8MaxIndex] = n;
                }
            }, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.log.log(Level.WARNING, "Could not create an UTF-8 reader", unsupportedEncodingException);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            try {
                this.temp = File.createTempFile("dtfj", ".txt");
                this.fout = new FileOutputStream(this.temp);
            }
            catch (Exception exception) {
                this.log.warning("Could not create temporary file to log the output");
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.reader == null) {
            return this.in.read();
        }
        if (this.utf8Index <= this.utf8MaxIndex) {
            return this.utf8Data[this.utf8Index++];
        }
        if (this.eos) {
            return -1;
        }
        char c = this.getData();
        if (this.eos) {
            return -1;
        }
        this.utf8MaxIndex = -1;
        this.writer.write(c);
        this.writer.flush();
        this.utf8Index = 0;
        if (this.log.isLoggable(Level.FINEST)) {
            this.fout.write(c);
        }
        return this.utf8Data[this.utf8Index++];
    }

    private char getData() throws IOException {
        char c = this.readNextChar();
        if (this.eos) {
            return '\u0000';
        }
        switch (this.state) {
            case 1: {
                return this.doStartTag(c);
            }
            case 6: 
            case 7: {
                return this.doMissingClosingTag(c);
            }
            case 4: {
                return this.doAttributes(c);
            }
            case 5: {
                return this.doAttributeContents(c);
            }
            case 3: {
                return this.doTagContents(c);
            }
            case 2: {
                return this.doCloseTag(c);
            }
        }
        throw new IllegalStateException("An unknown state of " + this.state + " was encountered");
    }

    private char doCloseTag(char c) throws IOException {
        if (c == '>') {
            this.state = 3;
            this.doStackIntegrityCheck(this.tags.pop());
        } else {
            this.name.append(c);
        }
        return c;
    }

    private char doTagContents(char c) throws IOException {
        if (c == '<') {
            if (!this.tags.isEmpty()) {
                this.peekName = this.peekTagFromStream(' ');
                char c2 = this.peekName.charAt(0);
                if ('!' == c2 || '?' == c2) {
                    return c;
                }
                if (this.tags.peek().equals(this.peekName)) {
                    this.missingDataIndex = 0;
                    this.missingDataBuffer = new StringBuffer();
                    this.missingDataBuffer.append("/");
                    this.missingDataBuffer.append(this.tags.peek());
                    this.missingDataBuffer.append("><");
                    this.tags.pop();
                    this.state = 7;
                    return c;
                }
            }
            this.state = 1;
            this.name = new StringBuffer();
        }
        return c;
    }

    private char doAttributeContents(char c) throws IOException {
        if (c == '\"' || c == '\'') {
            this.state = 4;
        }
        return c;
    }

    private char doMissingClosingTag(char c) throws IOException {
        if (this.missingDataIndex == this.missingDataBuffer.length()) {
            switch (this.state) {
                case 6: {
                    this.state = 2;
                    break;
                }
                case 7: {
                    this.state = 1;
                    this.name = new StringBuffer();
                    break;
                }
            }
        }
        return c;
    }

    private char doAttributes(char c) throws IOException {
        switch (c) {
            case '/': {
                this.state = 3;
                this.doStackIntegrityCheck(this.tags.pop());
                break;
            }
            case '>': {
                this.state = 3;
                break;
            }
            case '\"': 
            case '\'': {
                this.state = 5;
                break;
            }
        }
        return c;
    }

    private char doStartTag(char c) throws IOException {
        String string = null;
        switch (c) {
            case ' ': {
                string = this.name.toString();
                this.tags.push(string);
                this.state = 4;
                break;
            }
            case '/': {
                this.peekName = this.peekTagFromStream('>');
                if (this.peekName.equals(this.tags.peek())) {
                    this.state = 2;
                    break;
                }
                this.missingDataIndex = 0;
                this.missingDataBuffer = new StringBuffer();
                do {
                    string = (String)this.tags.pop();
                    this.missingDataBuffer.append(string);
                    this.missingDataBuffer.append("></");
                } while (!this.tags.peek().equals(this.peekName));
                this.state = 6;
                break;
            }
            case '!': 
            case '?': {
                this.state = 3;
                break;
            }
            default: {
                this.name.append(c);
            }
        }
        return c;
    }

    private char readNextChar() throws IOException {
        switch (this.state) {
            case 6: 
            case 7: {
                return this.missingDataBuffer.charAt(this.missingDataIndex++);
            }
        }
        return this.readFromBuffer();
    }

    private String peekTagFromStream(char c) throws IOException {
        try {
            int n = this.index;
            String string = (String)this.tags.peek();
            int n2 = this.availableBufferDataLength();
            if (string.length() > n2) {
                System.arraycopy(this.buffer, this.index, this.buffer, 0, n2);
                this.putDataIntoBuffer(n2);
                n = 0;
            }
            while (n < this.indexMax && this.buffer[n] != c) {
                ++n;
            }
            return new String(this.buffer, this.index, n - this.index);
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "Failed to peek the next tag from the stream", exception);
            return "";
        }
    }

    private void doStackIntegrityCheck(Object object) {
        String string = this.name.toString();
        if (!string.equals(object)) {
            this.log.severe("Tag mismatch : processing " + string + " but stack top is " + object);
        }
    }

    private int availableBufferDataLength() {
        return this.indexMax - this.index;
    }

    private char readFromBuffer() throws IOException {
        if (this.index == this.indexMax) {
            this.putDataIntoBuffer(0);
            if (this.eos) {
                return '\u0000';
            }
        }
        return this.buffer[this.index++];
    }

    private void putDataIntoBuffer(int n) throws IOException {
        int n2 = this.reader.read(this.buffer, n, 4096 - n);
        if (n2 == -1) {
            this.eos = true;
            this.indexMax = -1;
        } else {
            this.indexMax = n + n2;
            this.index = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.log.isLoggable(Level.FINEST) && !this.outputWritten) {
            this.fout.close();
            this.log.finest("Output sent to file " + this.temp.getAbsolutePath() + "\n");
            this.outputWritten = true;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void releaseResources() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            Logger.getLogger("com.ibm.dtfj.log").log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }
}

