/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.nativememory;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.INativeMemoryTypes;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.NativeMemoryPatternMatchers;

public class NativeMemoryTagParser
extends TagParser
implements INativeMemoryTypes {
    public NativeMemoryTagParser() {
        super("NATIVEMEMINFO");
    }

    @Override
    protected void initTagAttributeRules() {
        this.addTag("0MEMUSER", null);
        for (int i = 1; i < T_MEMUSERS.length; ++i) {
            this.addTag(T_MEMUSERS[i], new NativeMemoryUserLineRule(i));
        }
    }

    private static class NativeMemoryUserLineRule
    extends LineRule {
        private final int depth;

        NativeMemoryUserLineRule(int n) {
            this.depth = n;
        }

        @Override
        protected void processLine(String string, int n) {
            boolean bl;
            this.addToken("nativemem_depth", Integer.toString(this.depth));
            boolean bl2 = this.consumeUntilFirstMatch(NativeMemoryPatternMatchers.pipes);
            boolean bl3 = this.consumeUntilFirstMatch(NativeMemoryPatternMatchers.crossminusminus);
            boolean bl4 = bl = this.depth == 1 && bl2;
            if (bl || bl3) {
                this.addToken("nativemem_name", NativeMemoryPatternMatchers.categoryName);
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("nativemem_deepbytes", NativeMemoryPatternMatchers.commaDelimitedNumeric);
                this.consumeUntilFirstMatch(NativeMemoryPatternMatchers.bytesAndSeparator);
                this.addToken("nativemem_allocations", NativeMemoryPatternMatchers.commaDelimitedNumeric);
            }
        }
    }
}

