/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.javacore.builder.IImageBuilderFactory;
import com.ibm.dtfj.javacore.parser.framework.parser.IErrorListener;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.DTFJComponentLoader;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import com.ibm.dtfj.javacore.parser.j9.ParserController;
import com.ibm.dtfj.javacore.parser.j9.registered.RegisteredComponents;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaCoreReader {
    private RegisteredComponents fComponents;
    private IImageBuilderFactory fImageBuilderFactory;

    public JavaCoreReader(IImageBuilderFactory iImageBuilderFactory) {
        this.fImageBuilderFactory = iImageBuilderFactory;
        this.fComponents = new RegisteredComponents();
    }

    public Image generateImage(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[256];
            inputStream.read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Charset charset = this.getJavaCoreCodePage(byteArrayInputStream);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream);
            InputStreamReader inputStreamReader = charset != null ? new InputStreamReader((InputStream)sequenceInputStream, charset) : new InputStreamReader(sequenceInputStream);
            List list = new DTFJComponentLoader().loadSections();
            ParserController parserController = new ParserController(list, this.fImageBuilderFactory);
            parserController.addErrorListener(new IErrorListener(){
                private Logger logger = Logger.getLogger("com.ibm.dtfj.log");

                @Override
                public void handleEvent(String string) {
                    this.logger.fine(string);
                }
            });
            J9TagManager j9TagManager = J9TagManager.getCurrent();
            return parserController.parse(this.fComponents.getScannerManager(inputStreamReader, j9TagManager));
        }
        catch (ParserException parserException) {
            IOException iOException = new IOException("Error parsing Javacore");
            iOException.initCause(parserException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Charset getJavaCoreCodePage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byteArrayInputStream.mark(256);
        Charset charset = null;
        try {
            byte[] byArray = new byte[256];
            byteArrayInputStream.read(byArray);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            String[] stringArray = new String[]{"IBM1047", "UTF-16BE", "UTF-16LE", System.getProperty("file.encoding"), "IBM850"};
            try {
                for (int i = 0; i < stringArray.length && charset == null; ++i) {
                    charset = this.attemptCharset(byteBuffer, Charset.forName(stringArray[i]));
                }
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        catch (JavacoreFileEncodingException javacoreFileEncodingException) {
            Logger.getLogger("com.ibm.dtfj.log").log(Level.INFO, javacoreFileEncodingException.getMessage());
        }
        finally {
            byteArrayInputStream.reset();
        }
        return charset;
    }

    private Charset attemptCharset(ByteBuffer byteBuffer, Charset charset) throws JavacoreFileEncodingException {
        byteBuffer.rewind();
        String string = charset.decode(byteBuffer).toString();
        if (string.indexOf("0SECTION") >= 0) {
            int n = string.indexOf("1TICHARSET");
            if (n >= 0) {
                String string2 = string.substring(n += "1TICHARSET".length()).trim();
                string2 = string2.split("\\s+")[0];
                try {
                    Charset charset2;
                    try {
                        charset2 = Charset.forName(string2);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        charset2 = Charset.forName("cp" + string2);
                    }
                    ByteBuffer byteBuffer2 = charset.encode("0SECTION");
                    ByteBuffer byteBuffer3 = charset2.encode("0SECTION");
                    if (byteBuffer2.equals(byteBuffer3)) {
                        return charset2;
                    }
                    throw new JavacoreFileEncodingException("Ignoring Javacore encoding '" + string2 + "' hinted at by '" + "1TICHARSET" + "' eye catcher due to suspected change of encoding.\nEye catcher was readable using encoding '" + charset.displayName() + "'.");
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new JavacoreFileEncodingException("Unable to use Javacore encoding '" + string2 + "' hinted at by '" + "1TICHARSET" + "' eye catcher as the JVM does not support this encoding.", unsupportedCharsetException);
                }
            }
            return charset;
        }
        return null;
    }

    private class JavacoreFileEncodingException
    extends Exception {
        public JavacoreFileEncodingException(String string) {
            super(string);
        }

        public JavacoreFileEncodingException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

