/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.javacore.JCImage;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageSection;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;
import com.ibm.dtfj.javacore.builder.javacore.BuilderContainer;
import com.ibm.dtfj.javacore.builder.javacore.ImageProcessBuilder;

public class ImageAddressSpaceBuilder
extends AbstractBuilderComponent
implements IImageAddressSpaceBuilder {
    private JCImageAddressSpace fImageAddressSpace;
    private BuilderContainer fBuilderContainer;

    public ImageAddressSpaceBuilder(JCImage jCImage, String string) throws JCInvalidArgumentsException {
        super(string);
        if (jCImage == null) {
            throw new JCInvalidArgumentsException("An image address space builder must have a valid image");
        }
        this.fImageAddressSpace = new JCImageAddressSpace(jCImage);
        this.fBuilderContainer = this.getBuilderContainer();
    }

    @Override
    public IImageProcessBuilder getCurrentImageProcessBuilder() {
        return (IImageProcessBuilder)((Object)this.fBuilderContainer.getLastAdded());
    }

    @Override
    public IImageProcessBuilder generateImageProcessBuilder(String string) throws BuilderFailureException {
        ImageProcessBuilder imageProcessBuilder = null;
        if (this.getImageProcessBuilder(string) == null) {
            try {
                imageProcessBuilder = new ImageProcessBuilder(this.fImageAddressSpace, string);
                if (!(imageProcessBuilder instanceof AbstractBuilderComponent)) {
                    throw new BuilderFailureException(imageProcessBuilder.toString() + " must also be an " + AbstractBuilderComponent.class);
                }
                this.fBuilderContainer.add(imageProcessBuilder);
            }
            catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
                throw new BuilderFailureException(jCInvalidArgumentsException);
            }
        }
        return imageProcessBuilder;
    }

    @Override
    public IImageProcessBuilder getImageProcessBuilder(String string) {
        return (IImageProcessBuilder)((Object)this.fBuilderContainer.findComponent(string));
    }

    @Override
    public ImageSection addImageSection(String string, long l, long l2) {
        ImagePointer imagePointer = this.fImageAddressSpace.getPointer(l);
        JCImageSection jCImageSection = new JCImageSection(string, imagePointer, l2);
        this.fImageAddressSpace.addImageSection(jCImageSection);
        return jCImageSection;
    }
}

