/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.util;

import java.io.Serializable;
import java.util.Random;

public final class BitStream
implements Serializable {
    private int[] bits;
    private int index;
    private int bitOffset;
    private boolean writing = true;
    private int currentWord;
    private static final int[] log2bytes = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    static final int[] nextUnsetBit = new int[256];

    public BitStream() {
        this(25);
    }

    public BitStream(int n) {
        this.bits = new int[n];
    }

    public void rewind() {
        this.index = 0;
        this.bitOffset = 0;
        this.writing = false;
        this.currentWord = this.bits[this.index];
    }

    public void reset() {
        this.rewind();
        this.bits[0] = 0;
        this.writing = true;
    }

    private void writeIntInWord(int n, int n2) {
        assert (n2 > 0) : n2;
        if (n2 < 32) {
            n &= (1 << n2) - 1;
        }
        int n3 = this.bits[this.index];
        this.bits[this.index] = n3 |= n << 32 - (this.bitOffset + n2);
        this.bitOffset += n2;
    }

    public void writeLongBits(long l, int n) {
        assert (n < 64) : n;
        this.writeIntBits((int)(l >> 32), n - 32);
        this.writeIntBits((int)l, 32);
    }

    public void writeIntBits(int n, int n2) {
        assert (n2 > 0 && n2 <= 32) : n2;
        if (n2 < 32 - this.bitOffset) {
            this.writeIntInWord(n, n2);
        } else {
            int n3 = 32 - this.bitOffset;
            int n4 = n2 + this.bitOffset - 32;
            if (n3 > 0) {
                this.writeIntInWord(n >>> n4, n3);
            }
            if (n4 > 0) {
                this.nextWord();
                this.bits[this.index] = 0;
                this.writeIntInWord(n, n4);
            }
        }
    }

    public void nextWord() {
        ++this.index;
        if (this.index >= this.bits.length) {
            int[] nArray = new int[this.bits.length * 2];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        } else if (this.writing) {
            this.bits[this.index] = 0;
        }
        this.currentWord = this.bits[this.index];
        this.bitOffset = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        assert (!this.writing);
        this.index = n;
        this.currentWord = this.bits[n];
        this.bitOffset = 0;
    }

    private int readIntInWord(int n) {
        int n2 = this.currentWord >> 32 - (this.bitOffset + n);
        if (n < 32) {
            n2 &= (1 << n) - 1;
        }
        this.bitOffset += n;
        return n2;
    }

    public int readIntBits(int n) {
        assert (n > 0 && n <= 32) : n;
        if (n < 32 - this.bitOffset) {
            return this.readIntInWord(n);
        }
        int n2 = 32 - this.bitOffset;
        int n3 = n + this.bitOffset - 32;
        int n4 = 0;
        if (n2 > 0) {
            n4 = this.readIntInWord(n2);
        }
        int n5 = 0;
        if (n3 > 0) {
            this.nextWord();
            n5 = this.readIntInWord(n3);
        }
        return n4 << n3 | n5;
    }

    public long readLongBits(int n) {
        assert (n < 64) : n;
        if (n <= 32) {
            return this.readIntBits(n);
        }
        long l = this.readIntBits(n - 32);
        assert (l >= 0L) : l;
        long l2 = this.readIntBits(32);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public static int log2(int n) {
        int n2 = 0;
        while ((n & 0xFFFFFF00) != 0) {
            n2 += 8;
            n >>>= 8;
        }
        return n2 + log2bytes[n];
    }

    public int writeDelta(int n) {
        int n2 = BitStream.log2(++n);
        int n3 = this.writeGamma(n2);
        if (n2 != 0) {
            this.writeIntBits(n, n2);
        }
        return n3 + n2;
    }

    public int writeGamma(int n) {
        int n2 = BitStream.log2(++n);
        int n3 = this.writeUnary(n2);
        if (n2 != 0) {
            this.writeIntBits(n, n2);
        }
        return n3 + n2;
    }

    public int writeUnary(int n) {
        for (int i = 0; i < n; ++i) {
            this.writeIntBits(1, 1);
        }
        this.writeIntBits(0, 1);
        return n + 1;
    }

    public int readDelta() {
        int n = this.readGamma();
        return n == 0 ? 0 : (1 << n | this.readIntBits(n)) - 1;
    }

    public int readGamma() {
        int n = this.readUnary();
        return n == 0 ? 0 : (1 << n | this.readIntBits(n)) - 1;
    }

    public int readUnary() {
        int n = this.currentWord;
        int n2 = this.bitOffset;
        int n3 = 0;
        while (n2 <= 24) {
            int n4 = nextUnsetBit[n >> 24 - n2 & 0xFF];
            if (n4 != -1) {
                this.bitOffset = n2 + n4 + 1;
                return n3 + n4;
            }
            n2 += 8;
            n3 += 8;
        }
        while (true) {
            if (n2 == 32) {
                this.nextWord();
                n = this.currentWord;
                n2 = 0;
            }
            if ((n & Integer.MIN_VALUE >>> n2) == 0) {
                this.bitOffset = n2 + 1;
                return n3;
            }
            ++n3;
            ++n2;
        }
    }

    public int writeVariableByte(int n) {
        return this.writevb(n, true);
    }

    private int writevb(int n, boolean bl) {
        int n2 = 0;
        if (n >= 128 || n < 0) {
            n2 += this.writevb(n >>> 7, false);
        }
        n &= 0x7F;
        if (bl) {
            n |= 0x80;
        }
        this.writeIntBits(n, 8);
        return n2 + 8;
    }

    public int readVariableByte() {
        int n = 0;
        while (true) {
            int n2 = this.readIntBits(8);
            n |= n2 & 0x7F;
            if ((n2 & 0x80) != 0) {
                return n;
            }
            n <<= 7;
        }
    }

    public int writeGolombRice(int n, int n2) {
        int n3 = this.writeUnary(n >>> n2);
        this.writeIntBits(n, n2);
        return n3 + n2;
    }

    public int readGolombRice(int n) {
        int n2 = this.readUnary() << n;
        return n2 | this.readIntBits(n);
    }

    public int memoryUsage() {
        return this.bits.length * 4;
    }

    public static void main(String[] stringArray) {
        BitStream bitStream = new BitStream();
        Random random = new Random(0L);
        if (stringArray.length != 0) {
            for (int i = 0; i < 4000; ++i) {
                System.out.println("" + i + ": gamma " + bitStream.writeGamma(i) + " delta " + bitStream.writeDelta(i) + " variable " + bitStream.writeVariableByte(i) + " g(2) " + bitStream.writeGolombRice(i, 2) + " g(3) " + bitStream.writeGolombRice(i, 3) + " g(5) " + bitStream.writeGolombRice(i, 5) + " g(7) " + bitStream.writeGolombRice(i, 7) + " g(8) " + bitStream.writeGolombRice(i, 8));
                bitStream.reset();
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int n;
            int n2;
            int n3;
            bitStream.reset();
            int[] nArray = new int[8000];
            byte[] byArray = new byte[8000];
            byte[] byArray2 = new byte[8000];
            block16: for (n3 = 0; n3 < 8000; ++n3) {
                int n4;
                n2 = random.nextInt(31);
                n = 1 << n2;
                nArray[n3] = n4 = random.nextInt();
                byArray[n3] = (byte)(random.nextInt(5) + 1);
                switch (byArray[n3]) {
                    case 1: {
                        System.out.println("doing " + n3 + " n " + n4 + " code " + byArray[n3]);
                        bitStream.writeDelta(n4);
                        continue block16;
                    }
                    case 2: {
                        System.out.println("doing " + n3 + " n " + n4 + " code " + byArray[n3]);
                        bitStream.writeGamma(n4);
                        continue block16;
                    }
                    case 3: {
                        byArray2[n3] = (byte)(random.nextInt(32) + 1);
                        bitStream.writeIntBits(n4, byArray2[n3]);
                        int n5 = (int)((1L << byArray2[n3]) - 1L);
                        int n6 = n3;
                        nArray[n6] = nArray[n6] & n5;
                        System.out.println("doing " + n3 + " n " + n4 + " code " + byArray[n3] + " bits " + byArray2[n3]);
                        continue block16;
                    }
                    case 4: {
                        System.out.println("doing " + n3 + " n " + n4 + " code " + byArray[n3]);
                        bitStream.writeVariableByte(n4);
                        continue block16;
                    }
                    case 5: {
                        byArray2[n3] = (byte)(random.nextInt(8) + 15);
                        System.out.println("doing " + n3 + " n " + n4 + " code " + byArray[n3] + " k " + byArray2[n3]);
                        bitStream.writeGolombRice(n4, byArray2[n3]);
                    }
                }
            }
            System.out.println("done write for " + i);
            bitStream.rewind();
            block17: for (n3 = 0; n3 < 8000; ++n3) {
                n2 = nArray[n3];
                switch (byArray[n3]) {
                    case 1: {
                        n = bitStream.readDelta();
                        System.out.println("doing " + n3 + " k " + n + " code " + byArray[n3]);
                        if (n == n2) continue block17;
                        throw new Error("delta: expected " + n2 + " but got " + n);
                    }
                    case 2: {
                        n = bitStream.readGamma();
                        System.out.println("doing " + n3 + " k " + n + " code " + byArray[n3]);
                        if (n == n2) continue block17;
                        throw new Error("gamma: expected " + n2 + " but got " + n);
                    }
                    case 3: {
                        n = bitStream.readIntBits(byArray2[n3]);
                        System.out.println("doing " + n3 + " k " + n + " code " + byArray[n3] + " bits " + byArray2[n3]);
                        if (n == n2) continue block17;
                        throw new Error("fixed bits: expected " + n2 + " but got " + n);
                    }
                    case 4: {
                        n = bitStream.readVariableByte();
                        System.out.println("doing " + n3 + " k " + n + " code " + byArray[n3]);
                        if (n == n2) continue block17;
                        throw new Error("variable byte: expected " + n2 + " but got " + n);
                    }
                    case 5: {
                        n = bitStream.readGolombRice(byArray2[n3]);
                        System.out.println("doing " + n3 + " k " + n + " code " + byArray[n3]);
                        if (n == n2) continue block17;
                        throw new Error("golomb: expected " + n2 + " but got " + n);
                    }
                }
            }
            System.out.println("done " + i);
        }
    }

    static {
        block0: for (int i = 0; i < 256; ++i) {
            BitStream.nextUnsetBit[i] = -1;
            for (int j = 0; j < 8; ++j) {
                if ((128 >> j & i) != 0) continue;
                BitStream.nextUnsetBit[i] = j;
                continue block0;
            }
        }
    }
}

