/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.dtfj.corereaders.NewWinDump;
import com.ibm.dtfj.corereaders.NewZosDump;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DumpFactory {
    public static ICoreFileReader createDumpForCore(ImageInputStream imageInputStream) throws IOException {
        return DumpFactory.createDumpForCore(imageInputStream, false);
    }

    public static ICoreFileReader createDumpForCore(ImageInputStream imageInputStream, boolean bl) throws IOException {
        ICoreFileReader iCoreFileReader = null;
        try {
            if (NewWinDump.isSupportedDump(imageInputStream)) {
                iCoreFileReader = NewWinDump.dumpFromFile(imageInputStream);
            } else if (NewElfDump.isSupportedDump(imageInputStream)) {
                iCoreFileReader = NewElfDump.dumpFromFile(imageInputStream, bl);
            } else if (NewAixDump.isSupportedDump(imageInputStream)) {
                iCoreFileReader = NewAixDump.dumpFromFile(imageInputStream);
            } else if (NewZosDump.isSupportedDump(imageInputStream)) {
                iCoreFileReader = NewZosDump.dumpFromFile(imageInputStream);
            }
        }
        catch (CorruptCoreException corruptCoreException) {
            throw new IOException("Core file was identified but found to be corrupt:  " + corruptCoreException.getMessage());
        }
        return iCoreFileReader;
    }
}

