/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ToolsRegistryOutputChannels
extends OutputStream {
    private static ToolsRegistryOutputChannels instance;
    private final List<IOutputChannel> channels;
    private ByteArrayOutputStream buffer;
    private final String charsetName;

    public static void initialize(String string) {
        if (instance == null) {
            instance = new ToolsRegistryOutputChannels(string);
        }
    }

    public static void addChannel(IOutputChannel iOutputChannel) {
        ToolsRegistryOutputChannels.instance.channels.add(iOutputChannel);
    }

    public static void removeChannel(IOutputChannel iOutputChannel) {
        ToolsRegistryOutputChannels.instance.channels.remove(iOutputChannel);
    }

    public static boolean contains(IOutputChannel iOutputChannel) {
        return ToolsRegistryOutputChannels.instance.channels.contains(iOutputChannel);
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer.write(n);
        if (10 == n || 21 == n) {
            this.writeBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer();
        for (IOutputChannel iOutputChannel : this.channels) {
            iOutputChannel.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer();
        for (IOutputChannel iOutputChannel : this.channels) {
            iOutputChannel.flush();
        }
    }

    public static PrintStream newPrintStream() {
        return new PrintStream(instance, true);
    }

    private ToolsRegistryOutputChannels(String string) {
        this.charsetName = string;
        this.channels = new ArrayList<IOutputChannel>();
        this.buffer = new ByteArrayOutputStream();
    }

    private void writeBuffer() throws IOException {
        if (0 != this.buffer.size()) {
            String string = this.charsetName == null ? this.buffer.toString() : this.buffer.toString(this.charsetName);
            this.buffer = new ByteArrayOutputStream();
            for (IOutputChannel iOutputChannel : this.channels) {
                iOutputChannel.print(string);
            }
        }
    }
}

