/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoSymCommand
extends BaseJdmpviewCommand {
    protected static final String longDesc = "parameters: none, module name\n\nif no parameters are passed then for each process in the address spaces, outputs a list of module sections for each module with their start and end addresses, names, and sizes\nif a module name is passed then it outputs the above information for that module plus a list of all the known symbols for that module. Module names can be specified with leading or trailing * characters to save specifying full paths or remembering what file extension is used on this platform. e.g. info mod *libzip* info mod * will all modules with sections and symbols.";

    public InfoSymCommand() {
        this.addCommand("info sym", "", "an alias for 'mod'");
        this.addCommand("info mod", "", "outputs module information");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        switch (stringArray.length) {
            case 0: {
                this.listModules(null);
                break;
            }
            case 1: {
                this.listModules(stringArray[0]);
                break;
            }
            default: {
                printStream.println("\"info sym\" command takes either 0 or 1 parameters");
            }
        }
    }

    private void listModules(String string) {
        Object object;
        Object object2;
        ImageProcess imageProcess = this.ctx.getProcess();
        try {
            object2 = imageProcess.getExecutable();
            if (object2 instanceof ImageModule) {
                object = object2;
                if (string != null) {
                    if (this.checkModuleName(object.getName(), string)) {
                        this.printModule((ImageModule)object, true);
                    }
                } else {
                    this.printModule((ImageModule)object, false);
                }
            } else if (object2 instanceof CorruptData) {
                object = (CorruptData)object2;
                this.out.print("\t  <corrupt executable encountered: " + object.toString() + ">\n\n");
            }
        }
        catch (DataUnavailable dataUnavailable) {
            this.out.println(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.println(Exceptions.getCorruptDataExceptionString());
        }
        try {
            object2 = imageProcess.getLibraries();
        }
        catch (DataUnavailable dataUnavailable) {
            object2 = null;
            this.out.println(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException corruptDataException) {
            object2 = null;
            this.out.println(Exceptions.getCorruptDataExceptionString());
        }
        while (null != object2 && object2.hasNext()) {
            Object object3;
            object = object2.next();
            if (object instanceof ImageModule) {
                object3 = object;
                String string2 = null;
                try {
                    string2 = object3.getName();
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.print("\t  <corrupt library name: " + object3.toString() + ">\n\n");
                }
                if (string != null) {
                    if (!this.checkModuleName(string2, string)) continue;
                    this.printModule((ImageModule)object3, true);
                    continue;
                }
                this.printModule((ImageModule)object3, false);
                continue;
            }
            if (object instanceof CorruptData) {
                object3 = (CorruptData)object;
                this.out.print("\t  <corrupt library encountered: " + object3.toString() + ">\n\n");
                continue;
            }
            this.out.print("\t  <corrupt library encountered>\n\n");
        }
    }

    private void printModule(ImageModule imageModule, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        try {
            this.out.print("\t  " + imageModule.getName());
        }
        catch (CorruptDataException corruptDataException) {
            this.out.print("\t  " + Exceptions.getCorruptDataExceptionString());
        }
        try {
            object3 = String.format("0x%x", imageModule.getLoadAddress());
            this.out.print(" @ " + (String)object3);
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        object3 = imageModule.getSections();
        if (object3.hasNext()) {
            this.out.print(", sections:\n");
        } else {
            this.out.print(", <no section information>\n");
        }
        while (object3.hasNext()) {
            object2 = object3.next();
            if (object2 instanceof ImageSection) {
                object = (ImageSection)object2;
                this.out.print("\t   0x" + Long.toHexString(object.getBaseAddress().getAddress()) + " - 0x" + Long.toHexString(object.getBaseAddress().getAddress() + object.getSize()));
                this.out.print(", name: \"");
                this.out.print(object.getName());
                this.out.print("\", size: 0x");
                this.out.print(Long.toHexString(object.getSize()));
                this.out.print("\n");
                continue;
            }
            if (object2 instanceof CorruptData) {
                this.out.print("\t   <corrupt section encountered>\n");
                continue;
            }
            this.out.print("\t   <corrupt section encountered>\n");
        }
        if (bl) {
            this.out.print("\t  symbols:\n");
            object2 = imageModule.getSymbols();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof ImageSymbol) {
                    ImageSymbol imageSymbol = (ImageSymbol)object;
                    this.out.print("\t   0x" + Long.toHexString(imageSymbol.getAddress().getAddress()));
                    this.out.print(", name: \"");
                    this.out.print(imageSymbol.getName());
                    this.out.print("\"\n");
                    continue;
                }
                if (object instanceof CorruptData) {
                    this.out.print("\t   <corrupt symbol encountered>\n");
                    continue;
                }
                this.out.print("\t   <corrupt symbol encountered>\n");
            }
        }
        this.out.print("\n");
    }

    private boolean checkModuleName(String string, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        if ((string2 = string2.trim()).startsWith("*")) {
            bl = true;
            if ((string2 = string2.substring(1)).length() == 0) {
                bl2 = true;
            }
        }
        if (string2.endsWith("*")) {
            bl2 = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!bl && !bl2 && string2.equals(string)) {
            return true;
        }
        if (bl && !bl2 && string.endsWith(string2)) {
            return true;
        }
        if (!bl && bl2 && string.startsWith(string2)) {
            return true;
        }
        return bl && bl2 && string.indexOf(string2) >= 0;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(longDesc);
    }
}

