/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaRuntimeMemorySection;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoMemoryCommand
extends BaseJdmpviewCommand {
    private static final String COM_IBM_DBGMALLOC_PROPERTY = "-Dcom.ibm.dbgmalloc=true";

    public InfoMemoryCommand() {
        this.addCommand("info memory", "", "Provides information about the native memory usage in the Java Virtual Machine");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        try {
            Iterator iterator = javaRuntime.getMemoryCategories();
            this.printAllMemoryCategories(printStream, iterator);
            this.printDbgmallocWarning(printStream, javaRuntime);
        }
        catch (DataUnavailable dataUnavailable) {
            printStream.println("Memory categories information unavailable.");
            this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
        }
    }

    private void printDbgmallocWarning(PrintStream printStream, JavaRuntime javaRuntime) {
        try {
            boolean bl = false;
            JavaVMInitArgs javaVMInitArgs = javaRuntime.getJavaVMInitArgs();
            if (javaVMInitArgs != null) {
                Iterator iterator = javaVMInitArgs.getOptions();
                while (iterator.hasNext()) {
                    JavaVMOption javaVMOption;
                    Object e = iterator.next();
                    if (!(e instanceof JavaVMOption) || !COM_IBM_DBGMALLOC_PROPERTY.equals((javaVMOption = (JavaVMOption)e).getOptionString())) continue;
                    bl = true;
                }
            }
            if (!bl) {
                printStream.println();
                printStream.printf("Note: %s was not found in the Java VM init options.\nMemory allocated by some class library components will not have been recorded.\n", COM_IBM_DBGMALLOC_PROPERTY);
            }
        }
        catch (DataUnavailable dataUnavailable) {
            printStream.println("Java VM init options information unavailable.");
            this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), dataUnavailable);
        }
        catch (CorruptDataException corruptDataException) {
            printStream.println("Corrupt Data encountered walking Java VM init options");
            this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
    }

    private void printAllMemoryCategories(PrintStream printStream, Iterator<?> iterator) {
        try {
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof JavaRuntimeMemoryCategory)) continue;
                JavaRuntimeMemoryCategory javaRuntimeMemoryCategory = (JavaRuntimeMemoryCategory)obj;
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                int n = InfoMemoryCommand.countPrintableChildren(javaRuntimeMemoryCategory);
                linkedList.addLast(n);
                this.printCategory(javaRuntimeMemoryCategory, linkedList, printStream);
            }
        }
        catch (CorruptDataException corruptDataException) {
            printStream.println("Corrupt Data encountered walking memory categories");
            this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
    }

    private void printCategory(JavaRuntimeMemoryCategory javaRuntimeMemoryCategory, LinkedList<Integer> linkedList, PrintStream printStream) {
        int n = linkedList.size() - 1;
        try {
            if (javaRuntimeMemoryCategory.getShallowBytes() > 0L || javaRuntimeMemoryCategory.getDeepBytes() > 0L) {
                InfoMemoryCommand.indentToDepth(new String[]{"|  ", "|  ", "   "}, linkedList, printStream, n);
                if (n > 0) {
                    printStream.println();
                }
                InfoMemoryCommand.indentToDepth(new String[]{"+--", "|  ", "   "}, linkedList, printStream, n);
                printStream.printf("%s: %d bytes / %d allocations\n", javaRuntimeMemoryCategory.getName(), javaRuntimeMemoryCategory.getDeepBytes(), javaRuntimeMemoryCategory.getDeepAllocations());
                if (javaRuntimeMemoryCategory.getDeepBytes() > javaRuntimeMemoryCategory.getShallowBytes()) {
                    Iterator iterator = javaRuntimeMemoryCategory.getChildren();
                    JavaRuntimeMemoryCategory javaRuntimeMemoryCategory2 = InfoMemoryCommand.getOtherCategory(javaRuntimeMemoryCategory);
                    while (iterator.hasNext()) {
                        int n2 = linkedList.get(n);
                        linkedList.set(n, --n2);
                        Object e = iterator.next();
                        if (!(e instanceof JavaRuntimeMemoryCategory)) continue;
                        JavaRuntimeMemoryCategory javaRuntimeMemoryCategory3 = (JavaRuntimeMemoryCategory)e;
                        int n3 = InfoMemoryCommand.countPrintableChildren(javaRuntimeMemoryCategory3);
                        linkedList.addLast(n3);
                        this.printCategory(javaRuntimeMemoryCategory3, linkedList, printStream);
                        linkedList.removeLast();
                    }
                    if (javaRuntimeMemoryCategory2 != null) {
                        linkedList.addLast(0);
                        this.printCategory(javaRuntimeMemoryCategory2, linkedList, printStream);
                        linkedList.removeLast();
                    }
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            printStream.println("Corrupt Data encountered walking memory categories");
            this.logger.log(Level.FINE, Exceptions.getCorruptDataExceptionString(), corruptDataException);
        }
    }

    private static int countPrintableChildren(JavaRuntimeMemoryCategory javaRuntimeMemoryCategory) throws CorruptDataException {
        int n = 0;
        if (javaRuntimeMemoryCategory.getDeepBytes() > javaRuntimeMemoryCategory.getShallowBytes()) {
            Iterator iterator = javaRuntimeMemoryCategory.getChildren();
            while (iterator.hasNext()) {
                JavaRuntimeMemoryCategory javaRuntimeMemoryCategory2;
                Object e = iterator.next();
                if (!(e instanceof JavaRuntimeMemoryCategory) || (javaRuntimeMemoryCategory2 = (JavaRuntimeMemoryCategory)e).getShallowBytes() <= 0L && javaRuntimeMemoryCategory2.getDeepBytes() <= 0L) continue;
                ++n;
            }
        }
        if (javaRuntimeMemoryCategory.getShallowAllocations() > 0L) {
            ++n;
        }
        return n;
    }

    private static JavaRuntimeMemoryCategory getOtherCategory(final JavaRuntimeMemoryCategory javaRuntimeMemoryCategory) throws CorruptDataException {
        if (javaRuntimeMemoryCategory.getShallowAllocations() == 0L) {
            return null;
        }
        JavaRuntimeMemoryCategory javaRuntimeMemoryCategory2 = new JavaRuntimeMemoryCategory(){

            public long getShallowBytes() throws CorruptDataException {
                return 0L;
            }

            public long getShallowAllocations() throws CorruptDataException {
                return 0L;
            }

            public String getName() throws CorruptDataException {
                return "Other";
            }

            public Iterator<JavaRuntimeMemorySection> getMemorySections(boolean bl) throws CorruptDataException, DataUnavailable {
                return null;
            }

            public long getDeepBytes() throws CorruptDataException {
                return javaRuntimeMemoryCategory.getShallowBytes();
            }

            public long getDeepAllocations() throws CorruptDataException {
                return javaRuntimeMemoryCategory.getShallowAllocations();
            }

            public Iterator<JavaRuntimeMemoryCategory> getChildren() throws CorruptDataException {
                return new Iterator<JavaRuntimeMemoryCategory>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public JavaRuntimeMemoryCategory next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        return javaRuntimeMemoryCategory2;
    }

    private static void indentToDepth(String[] stringArray, LinkedList<Integer> linkedList, PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                printStream.print(stringArray[0]);
                continue;
            }
            if (linkedList.get(i) > 0) {
                printStream.print(stringArray[1]);
                continue;
            }
            printStream.print(stringArray[2]);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("outputs a tree of native memory usage by each component in the Java Virtual Machine \n\nparameters: none\n");
    }
}

