/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.nio.ByteOrder;

@DTFJPlugin(version="1.*", runtime=false)
public class FindPtrCommand
extends BaseJdmpviewCommand {
    String pattern;

    public FindPtrCommand() {
        this.addCommand("findptr", "", "searches memory for the given pointer");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length == 1) {
            String[] stringArray2;
            String string2 = stringArray[0];
            if (string2.endsWith(",")) {
                string2 = string2 + "1";
            }
            if (!this.isParametersValid(stringArray2 = string2.split(","))) {
                return;
            }
            if (FindPtrCommand.isLittleEndian(iContext)) {
                this.pattern = this.reorderBytes();
            }
            String string3 = this.getParameters(stringArray2);
            printStream.println("issuing: find " + string3);
            this.ctx.execute("find " + string3, printStream);
        } else {
            printStream.println("\"find\" takes a set comma separated parameters with no spaces");
        }
    }

    private String getParameters(String[] stringArray) {
        String string = "0x" + this.pattern;
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + "," + stringArray[i];
        }
        return string;
    }

    private String reorderBytes() {
        if (0 != this.pattern.length() % 2) {
            this.pattern = "0" + this.pattern;
        }
        String string = "";
        for (int i = this.pattern.length() / 2 - 1; i >= 0; --i) {
            string = string + this.pattern.substring(i * 2, i * 2 + 2);
        }
        return string;
    }

    private static boolean isLittleEndian(IContext iContext) {
        ImageAddressSpace imageAddressSpace;
        return iContext instanceof IDTFJContext && ByteOrder.LITTLE_ENDIAN == (imageAddressSpace = ((IDTFJContext)iContext).getAddressSpace()).getByteOrder();
    }

    private boolean isParametersValid(String[] stringArray) {
        if (6 != stringArray.length) {
            this.out.println("insufficient number of parameters");
            return false;
        }
        this.pattern = stringArray[0];
        if (this.pattern.equals("")) {
            this.out.println("missing pattern string");
            return false;
        }
        if (this.pattern.startsWith("0x")) {
            this.pattern = this.pattern.substring(2);
        }
        return true;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("searches memory for the given pointer\n\nparameters: see parameters for \"find\" command\n\nthe findptr command searches for <pattern> as a pointer in the memory segment from <start_address> to <end_address> (both inclusive), and outputs the first <matches_to_display> matching addresses that start at the corresponding <memory_boundary>. It also display the next <bytes_to_print> bytes for the last match.");
    }
}

