/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class FindCommand
extends BaseJdmpviewCommand {
    static final int text = 1;
    static final int binary = 2;
    FindAttribute findAtt = new FindAttribute();
    StringBuffer sb = new StringBuffer();
    ArrayList<Long> matches = new ArrayList();

    public FindCommand() {
        this.addCommand("find", "", "searches memory for a given string. Please run \"help find\" for details.");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length == 1) {
            String string2 = stringArray[0];
            if (string2.endsWith(",")) {
                string2 = string2 + "1";
            }
            String[] stringArray2 = string2.split(",");
            this.doCommand(stringArray2);
        } else {
            printStream.println("\"find\" takes a set comma separated parameters with no spaces. Please run \"help find\" for details.");
        }
    }

    public void doCommand(String[] stringArray) {
        ImageSection imageSection;
        this.sb = new StringBuffer();
        this.matches.clear();
        if (!this.isParametersValid(stringArray)) {
            return;
        }
        this.determineModeFromPattern();
        if (!this.parseParams(stringArray)) {
            return;
        }
        Iterator iterator = this.ctx.getAddressSpace().getImageSections();
        while (iterator.hasNext() && this.matches.size() < this.findAtt.numMatchesToDisplay && !this.scanImageSection(imageSection = (ImageSection)iterator.next())) {
        }
        if (this.matches.size() > 0) {
            this.findAtt.lastMatch = this.matches.get(this.matches.size() - 1);
        }
        this.ctx.getProperties().put("FindAttributes", this.findAtt);
        this.doPrint();
        if (this.matches.size() > 0) {
            this.printLastMatchContent();
        }
        this.restoreHexPrefix();
    }

    private void restoreHexPrefix() {
        if (this.findAtt.mode == 2) {
            this.findAtt.pattern = "0x" + this.findAtt.pattern;
        }
    }

    private void printLastMatchContent() {
        this.ctx.execute("hexdump 0x" + Long.toHexString(this.findAtt.lastMatch) + " " + this.findAtt.numBytesToPrint, this.out);
    }

    private void doPrint() {
        int n = this.matches.size();
        if (0 == n) {
            this.sb.append("No matches found.\n");
        } else {
            int n2 = Math.min(this.findAtt.numMatchesToDisplay, n);
            for (int i = 0; i < n2; ++i) {
                long l = this.matches.get(i);
                this.sb.append("#" + i + ": 0x" + Long.toHexString(l) + "\n");
            }
        }
        this.out.print(new String(this.sb));
    }

    private boolean scanImageSection(ImageSection imageSection) {
        long l = imageSection.getBaseAddress().getAddress();
        long l2 = l + imageSection.getSize() - 1L;
        if (this.findAtt.startAddress < l && this.findAtt.endAddress < l) {
            return false;
        }
        if (this.findAtt.startAddress > l2 && this.findAtt.endAddress > l2) {
            return false;
        }
        if (this.findAtt.startAddress >= l && this.findAtt.endAddress <= l2) {
            return this.scanRegion(this.findAtt.startAddress, this.findAtt.endAddress, imageSection);
        }
        if (this.findAtt.startAddress <= l && this.findAtt.endAddress <= l2 && this.findAtt.endAddress >= l) {
            return this.scanRegion(l, this.findAtt.endAddress, imageSection);
        }
        if (this.findAtt.startAddress <= l2 && this.findAtt.startAddress >= l && this.findAtt.endAddress >= l2) {
            return this.scanRegion(this.findAtt.startAddress, l2, imageSection);
        }
        return this.scanRegion(l, l2, imageSection);
    }

    private boolean scanRegion(long l, long l2, ImageSection imageSection) {
        ImagePointer imagePointer = imageSection.getBaseAddress();
        int n = this.findAtt.length();
        byte[] byArray = this.findAtt.getBytes();
        for (long i = 0L != l % (long)this.findAtt.boundary ? l - l % (long)this.findAtt.boundary + (long)this.findAtt.boundary : l; i <= l2; i += (long)this.findAtt.boundary) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                byte by = byArray[n2];
                try {
                    if (FindCommand.getByteFromImage(imagePointer, i + (long)n2) != by) break;
                    continue;
                }
                catch (MemoryAccessException memoryAccessException) {
                    return false;
                }
            }
            if (n2 < n) continue;
            this.matches.add(i);
            if (this.matches.size() != this.findAtt.numMatchesToDisplay) continue;
            return true;
        }
        return false;
    }

    private static byte getByteFromImage(ImagePointer imagePointer, long l) throws MemoryAccessException {
        long l2 = imagePointer.getAddress();
        try {
            return imagePointer.getByteAt(l - l2);
        }
        catch (CorruptDataException corruptDataException) {
            return 0;
        }
    }

    private boolean parseParams(String[] stringArray) {
        this.findAtt.startAddress = stringArray[1].isEmpty() ? 0L : Utils.longFromString(stringArray[1]);
        this.findAtt.endAddress = stringArray[2].isEmpty() ? Long.MAX_VALUE : Utils.longFromString(stringArray[2]);
        if (this.findAtt.startAddress > this.findAtt.endAddress) {
            this.out.println("start address must not be greater than end address");
            return false;
        }
        if (stringArray[3].isEmpty()) {
            this.findAtt.boundary = 1;
        } else {
            this.findAtt.boundary = Integer.parseInt(stringArray[3]);
            if (this.findAtt.boundary <= 0) {
                this.out.println("memory boundary must be a positive non-zero value");
                return false;
            }
        }
        if (stringArray[4].isEmpty()) {
            this.findAtt.numBytesToPrint = 256;
        } else {
            this.findAtt.numBytesToPrint = Integer.parseInt(stringArray[4]);
            if (this.findAtt.numBytesToPrint < 0) {
                this.out.println("bytes to print must be a non-negative value");
                return false;
            }
        }
        if (stringArray[5].isEmpty()) {
            this.findAtt.numMatchesToDisplay = 1;
        } else {
            this.findAtt.numMatchesToDisplay = Integer.parseInt(stringArray[5]);
            if (this.findAtt.numMatchesToDisplay < 0) {
                this.out.println("matches to display must be a non-negative value");
                return false;
            }
        }
        return true;
    }

    private void determineModeFromPattern() {
        if (this.findAtt.pattern.startsWith("0x")) {
            this.findAtt.pattern = this.findAtt.pattern.substring(2);
            this.findAtt.mode = 2;
            this.alignBits();
        } else {
            this.findAtt.mode = 1;
        }
    }

    private void alignBits() {
        int n = this.findAtt.pattern.length();
        if (0 != n % 2) {
            this.findAtt.pattern = "0" + this.findAtt.pattern;
        }
    }

    private boolean isParametersValid(String[] stringArray) {
        if (6 != stringArray.length) {
            this.out.println("incorrect number of parameters");
            return false;
        }
        this.findAtt.pattern = stringArray[0];
        if (this.findAtt.pattern.isEmpty()) {
            this.out.println("missing search pattern string");
            return false;
        }
        return true;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.format("searches memory for a given string%n%nparameters, comma separated: <pattern>,<start_address>,<end_address>,<memory_boundary>,<bytes_to_print>,<matches_to_display>%n%nThe find command searches for <pattern> in the memory segment from <start_address> to <end_address> inclusive,%nmatching only addresses that start at the specified <memory_boundary>, for example 1, 2, 4 or 8 bytes.%nIt displays <bytes_to_print> bytes from the final match, and lists the first <matches_to_display> matches found.%nexample: find J9,,,,64,3%n", new Object[0]);
    }

    static class FindAttribute {
        String pattern;
        long startAddress;
        long endAddress;
        int boundary;
        int numBytesToPrint;
        int numMatchesToDisplay;
        long lastMatch;
        int mode;

        FindAttribute() {
        }

        public int length() {
            if (this.mode == 2) {
                return this.pattern.length() / 2;
            }
            return this.pattern.length();
        }

        public byte[] getBytes() {
            if (this.mode == 1) {
                return this.pattern.getBytes();
            }
            byte[] byArray = new byte[this.length()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt(this.pattern.substring(i * 2, i * 2 + 2), 16);
            }
            return byArray;
        }
    }
}

